/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.ifaces;

import java.util.Collection;

/**
 * The Interface Subject.
 * 
 * @param <T>
 *            the generic type of the observable.
 * @param <O>
 *            the generic type of the observer
 */
public interface Subject<T, O extends Observer<T>>
{

	/**
	 * Adds the given observer.
	 *
	 * @param observer
	 *            the observer to be added.
	 */
	void addObserver(O observer);

	/**
	 * Removes the given observer.
	 *
	 * @param observer
	 *            the observer to be remove.
	 */
	void removeObserver(O observer);

	/**
	 * Adds the given observers.
	 *
	 * @param observers
	 *            the observers to be added.
	 */
	void addObservers(Collection<O> observers);

	/**
	 * Removes the given observers.
	 *
	 * @param observers
	 *            the observers to be remove.
	 */
	void removeObservers(Collection<O> observers);

	/**
	 * Update observers.
	 */
	void updateObservers();

	/**
	 * Gets the observable.
	 *
	 * @return the observable
	 */
	T getObservable();

	/**
	 * Sets the observable.
	 *
	 * @param observable
	 *            the new observable
	 */
	void setObservable(T observable);

}
