/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.exception.handlers;

import net.sourceforge.jaulp.designpattern.observer.exception.ExceptionEvent;
import net.sourceforge.jaulp.designpattern.observer.exception.ExceptionListener;

/**
 * The Class DefaultExceptionHandler.
 */
public class DefaultExceptionHandler extends AbstractExceptionHandler
{

	/** The serialVersionUID. */
	private static final long serialVersionUID = -7194471234913656513L;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void updateEvent(final ExceptionListener listener, final ExceptionEvent event)
	{
		listener.onException(event);
	}

	/**
	 * Update on exception.
	 *
	 * @param event
	 *            the event
	 */
	public void updateOnException(final ExceptionEvent event)
	{
		super.update(event);
	}

}