/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.exception;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * The Class ExceptionMessages.
 * 
 * @param <T>
 *            the generic type
 */
public class ExceptionMessages<T>
{

	/** Contains all exceptionmessages. */
	private final Map<String, Set<ExceptionMessage<T>>> exceptions = new HashMap<>();

	public void add(final Map<? extends String, ? extends Set<ExceptionMessage<T>>> keyListMap)
	{
		this.exceptions.putAll(keyListMap);
	}

	public void add(final String key, final ExceptionMessage<T> value)
	{
		Set<ExceptionMessage<T>> values = this.exceptions.get(key);
		if (null == values)
		{
			values = new HashSet<>();
			this.exceptions.put(key, values);
		}
		values.add(value);
	}

	public boolean containsKey(final String key)
	{
		return this.exceptions.containsKey(key);
	}

	public Set<ExceptionMessage<T>> get(final String key)
	{
		return this.exceptions.get(key);
	}

	public Set<String> getKeys()
	{
		return this.exceptions.keySet();
	}

	public int getSize()
	{
		return this.exceptions.size();
	}

	public boolean isEmpty()
	{
		return this.exceptions.isEmpty();
	}

	public Set<ExceptionMessage<T>> remove(final String key)
	{
		return this.exceptions.remove(key);
	}

	public void removeAll(final Collection<String> keys)
	{
		for (final String key : keys)
		{
			this.remove(key);
		}
	}

}
