/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.exception;

import java.util.Objects;

/**
 * The Class ExceptionEvent.
 */
public class ExceptionEvent
{

	/** The value. */
	private Throwable value;

	/**
	 * Gets the value.
	 *
	 * @return the value
	 */
	public Throwable getValue()
	{
		return value;
	}

	/**
	 * Sets the value.
	 *
	 * @param value
	 *            the new value
	 */
	public void setValue(Throwable value)
	{
		this.value = value;
	}

	public ExceptionEvent(Throwable value)
	{
		super();
		this.value = value;
	}

	/**
	 * Override hashCode.
	 *
	 * @return the Objects hashcode.
	 */
	@Override
	public int hashCode()
	{
		int hashCode = 1;
		hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
		return hashCode;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null)
		{
			return false;
		}
		if (getClass() != obj.getClass())
		{
			return false;
		}
		final ExceptionEvent other = (ExceptionEvent)obj;
		return Objects.equals(this.value, other.value);
	}

}