/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.event;

import java.util.Collection;

/**
 * The Interface EventSource.
 *
 * @param <T>
 *            the generic type
 */
public interface EventSource<T>
{

	/**
	 * Adds the given event listener to the eventListeners list.
	 *
	 * @param eventListener
	 *            the event listener
	 */
	void addEventListener(EventListener<T> eventListener);

	/**
	 * Removes the given event listener from the eventListeners list.
	 *
	 * @param eventListener
	 *            the event listener
	 */
	void removeEventListener(EventListener<T> eventListener);

	/**
	 * Adds the all given event listeners to the eventListeners list.
	 *
	 * @param eventListeners
	 *            the event listeners
	 */
	void addEventListeners(Collection<EventListener<T>> eventListeners);

	/**
	 * Removes the all given event listeners from the eventListeners list.
	 *
	 * @param eventListeners
	 *            the event listeners
	 */
	void removeEventListeners(Collection<EventListener<T>> eventListeners);

	/**
	 * Fire the given event.
	 *
	 * @param source
	 *            the source
	 */
	void fireEvent(T source);

}