/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageSubject<T> implements MessageSource<T>
{
	/**
	 * Initialize block.
	 **/
	{
		messageListeners = new ArrayList<>();
	}

	/** The source. */
	private T source;

	/** The event listeners. */
	private final List<MessageListener<T>> messageListeners;

	public MessageSubject()
	{
		super();
	}

	public MessageSubject(final T source)
	{
		super();
		this.source = source;
	}

	@Override
	public synchronized void addMessageListener(final MessageListener<T> messageListener)
	{
		messageListeners.add(messageListener);

	}

	@Override
	public synchronized void addMessageListeners(
		final Collection<MessageListener<T>> messageListeners)
	{
		this.messageListeners.addAll(messageListeners);
	}

	private synchronized void fireMessage()
	{
		for (MessageListener<T> messageListener : messageListeners)
		{
			messageListener.onMessage(source);
		}
	}

	@Override
	public synchronized void fireMessage(final T source)
	{
		this.source = source;
		fireMessage();
	}

	@Override
	public synchronized void removeMessageListener(final MessageListener<T> messageListener)
	{
		messageListeners.remove(messageListener);
	}

	@Override
	public synchronized void removeMessageListeners(
		final Collection<MessageListener<T>> messageListeners)
	{
		this.messageListeners.removeAll(messageListeners);
	}

}
