/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat.listener;

import java.util.Collection;

/**
 * The Interface MessageSource.
 * 
 * @param <T>
 *            the generic type
 */
public interface MessageSource<T>
{

	/**
	 * Adds the given messageListeners to the existing messageListeners list.
	 * 
	 * @param messageListener
	 *            the MessageListener object
	 */
	void addMessageListener(MessageListener<T> messageListener);

	/**
	 * Adds the all given messageListener to the existing messageListeners list.
	 * 
	 * @param messageListeners
	 *            the MessageListener objects
	 */
	void addMessageListeners(Collection<MessageListener<T>> messageListeners);

	/**
	 * Fire the given message.
	 * 
	 * @param source
	 *            the message source
	 */
	void fireMessage(T source);

	/**
	 * Removes the given MessageListener object from the existing messageListeners list.
	 * 
	 * @param messageListener
	 *            the MessageListener object
	 */
	void removeMessageListener(MessageListener<T> messageListener);

	/**
	 * Removes the all given MessageListener objects from the messageListeners list.
	 * 
	 * @param messageListeners
	 *            the MessageListener objects
	 */
	void removeMessageListeners(Collection<MessageListener<T>> messageListeners);

}