/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat.listener;

/**
 * The Class MessageObject.
 * 
 * @param <T>
 *            the generic type
 */
public class MessageObject<T>
{

	/**
	 * The object on which the message Event initially occurred.
	 */
	protected transient T source;

	/**
	 * Instantiates a new message object.
	 * 
	 * @param source
	 *            the source
	 */
	public MessageObject(final T source)
	{
		if (source == null)
		{
			throw new IllegalArgumentException("null source");
		}

		this.source = source;
	}

	/**
	 * Gets the source.
	 *
	 * @return the source
	 */
	public T getSource()
	{
		return source;
	}

}
