/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat.listener;

/**
 * The listener interface for receiving message events. The class that is interested in processing a
 * message implements this interface, and the object created with that class is registered with a
 * component using the component's <code>addMessageListener</code> method. When the message event
 * occurs, that object's appropriate method is invoked.
 * 
 * @param <T>
 *            the generic type from the message Event
 */
public interface MessageListener<T>
{

	/**
	 * Handles the given event.
	 *
	 * @param event
	 *            the event
	 */
	void onMessage(T event);

}