/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat;

public class User implements IUser<User>
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * User Name.
	 */
	private String name;
	/**
	 * User id number.
	 */
	private Integer id;

	public User(final String name, final Integer id)
	{
		super();
		this.name = name;
		this.id = id;
	}

	@Override
	public Integer getId()
	{
		return id;
	}

	@Override
	public String getName()
	{
		return name;
	}

	public void setId(final Integer id)
	{
		this.id = id;
	}

	public void setName(final String name)
	{
		this.name = name;
	}

	@Override
	public User getApplicationUser()
	{
		return this;
	}

	@Override
	public void setApplicationUser(User user)
	{


	}
}
