/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat;

public class StringMessage implements Message<String>
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String value;

	public StringMessage()
	{
		super();
	}

	public StringMessage(final String value)
	{
		super();
		this.value = value;
	}

	@Override
	public String getValue()
	{
		return value;
	}

	@Override
	public StringMessage setValue(final String value)
	{
		this.value = value;
		return this;
	}

	@Override
	public String toString()
	{
		return "StringMessage [value=" + value + "]";
	}

}
