/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat;

import java.io.Serializable;
import java.util.Date;

/**
 * The Class MessageRoomModel.
 *
 */
public class MessageRoomModel implements Serializable
{

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/** The chat room name. */
	private final String chatRoomName;

	/** The data. */
	private Byte[] data;

	/** The date. */
	private final Date date = new Date();

	/** The message. */
	private String message;

	/** The user. */
	private final IUser<?> user;

	/**
	 * Instantiates a new message room model.
	 *
	 * @param chatRoomName
	 *            the chat room name
	 * @param user
	 *            the user
	 * @param message
	 *            the message
	 * @param data
	 *            the data
	 */
	public MessageRoomModel(String chatRoomName, IUser<?> user, String message, Byte[] data)
	{
		super();
		this.chatRoomName = chatRoomName;
		this.user = user;
		this.message = message;
		this.data = data;
	}

	/**
	 * Gets the chat room name.
	 *
	 * @return the chat room name
	 */
	public String getChatRoomName()
	{
		return chatRoomName;
	}

	/**
	 * Gets the data.
	 *
	 * @return the data
	 */
	public Byte[] getData()
	{
		return data;
	}

	/**
	 * Gets the date.
	 *
	 * @return the date
	 */
	public Date getDate()
	{
		return date;
	}

	/**
	 * Gets the message.
	 *
	 * @return the message
	 */
	public String getMessage()
	{
		return message;
	}

	/**
	 * Gets the user.
	 *
	 * @return the user
	 */
	public IUser<?> getUser()
	{
		return user;
	}

	/**
	 * Sets the data.
	 *
	 * @param data
	 *            the new data
	 */
	public void setData(Byte[] data)
	{
		this.data = data;
	}

	/**
	 * Sets the message.
	 *
	 * @param message
	 *            the new message
	 */
	public void setMessage(String message)
	{
		this.message = message;
	}
}
