/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat;

import java.io.Serializable;

/**
 * The Interface Invitation.
 *
 * @param <M>
 *            the generic type
 */
public interface Invitation<M extends Message<?>> extends Serializable
{

	/**
	 * Gets the sender of this invitation.
	 *
	 * @return the sender of this invitation.
	 */
	IUser<?> getSender();

	/**
	 * Gets the recipient of this invitation.
	 *
	 * @return the recipient of this invitation.
	 */
	IUser<?> getRecipient();

	/**
	 * Checks if this invitation is accepted from the recipient.
	 *
	 * @return true, if it is accepted otherwise false.
	 */
	boolean isAccepted();

	/**
	 * Checks if the recipient wants that the sender sees that he denied his invitation.
	 *
	 * @return true, if the recipient wants that the sender sees that he denied his invitation
	 *         otherwise false.
	 */
	boolean isDeniedVisible();

	/**
	 * Gets the room for this invitation.
	 *
	 * @return the room for this invitation.
	 */
	Room<M> getRoom();
}
