/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer.chat;

import java.io.Serializable;

import net.sourceforge.jaulp.designpattern.observer.ifaces.DisplayViewElement;
import net.sourceforge.jaulp.designpattern.observer.ifaces.Observer;

public abstract class ChatRoomUser<M extends Message<?>>
	implements
		Observer<M>,
		DisplayViewElement,
		Serializable
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** The subject. */
	protected ChatRoom<M> subject;

	/** The observable. */
	private M observable;

	private final IUser<?> user;

	public ChatRoomUser(final ChatRoom<M> room, final IUser<?> user)
	{
		this.subject = room;
		this.observable = this.subject.getObservable();
		this.user = user;
		this.subject.addObserver(this);
	}

	public IUser<?> getUser()
	{
		return user;
	}

	public void send(final M message)
	{
		subject.setObservable(message);
	}

	/**
	 * Gets the observable object.
	 *
	 * @return the observable
	 */
	public synchronized M getObservable()
	{
		return observable;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized void update(final M observable)
	{
		this.observable = observable;
		displayView();
	}

}
