/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.observer;

import net.sourceforge.jaulp.designpattern.observer.ifaces.DisplayViewElement;
import net.sourceforge.jaulp.designpattern.observer.ifaces.Observer;
import net.sourceforge.jaulp.designpattern.observer.ifaces.Subject;


/**
 * A generic implementation from the Observer-Pattern.
 * 
 * @param <T>
 *            the generic type
 */
public abstract class AbstractObserver<T> implements Observer<T>, DisplayViewElement
{

	/** The subject. */
	protected Subject<T, Observer<T>> subject;

	/** The observable. */
	private T observable;

	/**
	 * Constructor for a new observer object.
	 *
	 * @param subject
	 *            the subject
	 */
	public AbstractObserver(final Subject<T, Observer<T>> subject)
	{
		this.subject = subject;
		this.observable = subject.getObservable();
		this.subject.addObserver(this);
	}

	/**
	 * Gets the observable object.
	 *
	 * @return the observable
	 */
	public synchronized T getObservable()
	{
		return observable;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public synchronized void update(final T observable)
	{
		this.observable = observable;
		displayView();
	}

}
