/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.designpattern.builder;

public final class Car
{

	public static void main(String... args)
	{
		// create the builder object...
		Car.Builder builder = new Car.Builder("Lamborgini");
		// create Car object using the builder...
		Car lamborgini = builder.model("Diablo").constructionYear(2006).build();
		System.out.println(lamborgini);
	}

	// all fields must be final so they are immutable objects
	private final String model;
	private final int constructionYear;
	private final String type;

	// private Constructor. Only the Builder can call it.
	private Car(Builder builder)
	{
		this.model = builder.model;
		this.type = builder.type;
		this.constructionYear = builder.constructionYear;
	}

	public String getModel()
	{
		return model;
	}

	public int getConstructionYear()
	{
		return constructionYear;
	}

	public String getType()
	{
		return type;
	}

	@Override
	public String toString()
	{
		return "Car{" + "type='" + type + '\'' + ", model='" + model + '\'' + ", constructionYear="
			+ constructionYear + '}';
	}

	public static class Builder
	{
		// mandatory fields
		private final String type;
		// optional fields
		private int constructionYear;
		private String model;

		public Builder(String type)
		{
			this.type = type;
		}

		public Builder model(String model)
		{
			this.model = model;
			return this;
		}

		public Builder constructionYear(int constructionYear)
		{
			this.constructionYear = constructionYear;
			return this;
		}

		public Car build()
		{
			return new Car(this);
		}
	}

}