/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.model.dropdownchoices;

import de.alpharogroup.collections.ListExtensions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.lang.Args;

public class TwoDropDownChoicesBean<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private T selectedRootOption;
    private T selectedChildOption;
    private Map<T, List<T>> modelsMap = new HashMap<T, List<T>>();
    private final List<T> rootChoices;
    private List<T> childChoices;

    public TwoDropDownChoicesBean(T selectedOption, Map<T, List<T>> modelsMap) {
        this.modelsMap = (Map)Args.notNull(modelsMap, (String)"modelsMap");
        this.rootChoices = new ArrayList<T>(modelsMap.keySet());
        this.selectedRootOption = Args.notNull(selectedOption, (String)"selectedOption");
        this.childChoices = this.getChildChoices();
    }

    public List<T> getChildChoices() {
        List<T> childChoices = this.getModelsMap().get(this.getSelectedRootOption());
        if (ListExtensions.isEmpty(childChoices)) {
            return Collections.emptyList();
        }
        return childChoices;
    }

    public T getSelectedRootOption() {
        return this.selectedRootOption;
    }

    public void setSelectedRootOption(T selectedRootOption) {
        this.selectedRootOption = selectedRootOption;
    }

    public T getSelectedChildOption() {
        return this.selectedChildOption;
    }

    public void setSelectedChildOption(T selectedChildOption) {
        this.selectedChildOption = selectedChildOption;
    }

    public Map<T, List<T>> getModelsMap() {
        return this.modelsMap;
    }

    public void setModelsMap(Map<T, List<T>> modelsMap) {
        this.modelsMap = modelsMap;
    }

    public List<T> getRootChoices() {
        return this.rootChoices;
    }
}

