/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.i18n.dropdownchoice.panels;

import de.alpharogroup.wicket.components.i18n.dropdownchoice.LocalisedDropDownChoice;
import de.alpharogroup.wicket.model.dropdownchoices.TwoDropDownChoicesBean;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.lang.Args;

public class DoubleDropDownPanel<T>
extends FormComponentPanel<TwoDropDownChoicesBean<T>> {
    private static final long serialVersionUID = 1L;
    public static final String ROOT_CHOICE_ID = "rootChoice";
    public static final String CHILD_CHOICE_ID = "childChoice";
    private DropDownChoice<T> rootChoice;
    private DropDownChoice<T> childChoice;
    private final IChoiceRenderer<T> rootRenderer;
    private final IChoiceRenderer<T> childRenderer;

    public DoubleDropDownPanel(String id, IModel<TwoDropDownChoicesBean<T>> model, IChoiceRenderer<T> rootRenderer, IChoiceRenderer<T> childRenderer) {
        super(id, (IModel)Args.notNull(model, (String)"model"));
        this.rootRenderer = (IChoiceRenderer)Args.notNull(rootRenderer, (String)"rootRenderer");
        this.childRenderer = (IChoiceRenderer)Args.notNull(childRenderer, (String)"childRenderer");
    }

    public void convertInput() {
        TwoDropDownChoicesBean modelObject = (TwoDropDownChoicesBean)this.getModelObject();
        this.setConvertedInput(modelObject);
    }

    protected DropDownChoice<T> newChildChoice(String id, IModel<TwoDropDownChoicesBean<T>> model) {
        PropertyModel selectedChildOptionModel = new PropertyModel(model, "selectedChildOption");
        PropertyModel childChoicesModel = PropertyModel.of(model, (String)"childChoices");
        LocalisedDropDownChoice cc = new LocalisedDropDownChoice<T>(id, (IModel)selectedChildOptionModel, (IModel)childChoicesModel, this.childRenderer){

            protected void onSelectionChanged(Object newSelection) {
                DoubleDropDownPanel.this.onChildSelectionChanged(newSelection);
            }

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }
        };
        cc.setOutputMarkupId(true);
        cc.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                DoubleDropDownPanel.this.onChildChoiceError(target, e);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                DoubleDropDownPanel.this.onChildChoiceUpdate(target);
            }
        }});
        return cc;
    }

    protected DropDownChoice<T> newRootChoice(String id, IModel<TwoDropDownChoicesBean<T>> model) {
        PropertyModel selectedRootOptionModel = PropertyModel.of(model, (String)"selectedRootOption");
        PropertyModel rootChoicesModel = PropertyModel.of(model, (String)"rootChoices");
        LocalisedDropDownChoice rc = new LocalisedDropDownChoice<T>(id, (IModel)selectedRootOptionModel, (IModel)rootChoicesModel, this.rootRenderer){

            protected void onSelectionChanged(Object newSelection) {
                DoubleDropDownPanel.this.onRootSelectionChanged(newSelection);
            }

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }
        };
        rc.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                DoubleDropDownPanel.this.onRootChoiceError(target, e);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                DoubleDropDownPanel.this.onRootChoiceUpdate(target);
            }
        }});
        return rc;
    }

    protected void onChildChoiceError(AjaxRequestTarget target, RuntimeException e) {
        System.err.println("onChildChoiceError:");
    }

    protected void onChildChoiceUpdate(AjaxRequestTarget target) {
        target.add(new Component[]{this.childChoice});
    }

    protected void onChildSelectionChanged(Object newSelection) {
        System.err.println("onChildSelectionChanged:" + newSelection);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.rootChoice = this.newRootChoice(ROOT_CHOICE_ID, this.getModel());
        componentArray[0] = this.rootChoice;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.childChoice = this.newChildChoice(CHILD_CHOICE_ID, this.getModel());
        componentArray2[0] = this.childChoice;
        this.add(componentArray2);
    }

    protected void onRootChoiceError(AjaxRequestTarget target, RuntimeException e) {
        System.err.println("onRootChoiceError:");
    }

    protected void onRootChoiceUpdate(AjaxRequestTarget target) {
        this.childChoice.modelChanging();
        target.add(new Component[]{this.childChoice});
        this.childChoice.modelChanged();
    }

    protected void onRootSelectionChanged(Object newSelection) {
        System.err.println("onRootSelectionChanged:" + newSelection);
    }

    public DropDownChoice<T> getRootChoice() {
        return this.rootChoice;
    }

    public DropDownChoice<T> getChildChoice() {
        return this.childChoice;
    }

    public IChoiceRenderer<T> getRootRenderer() {
        return this.rootRenderer;
    }

    public IChoiceRenderer<T> getChildRenderer() {
        return this.childRenderer;
    }
}

