/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.up;

import de.alpharogroup.auth.models.BaseUsernameSignUpModel;
import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledPasswordTextFieldPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import de.alpharogroup.wicket.components.sign.in.SigninPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupPanel<T extends BaseUsernameSignUpModel>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SignupPanel.class);
    private Component username;
    private SigninPanel<T> signinPanel;
    private LabeledPasswordTextFieldPanel<String, BaseUsernameSignUpModel> repeatPassword;

    public SignupPanel(String id, IModel<T> model) {
        super(id, model);
    }

    protected LabeledPasswordTextFieldPanel<String, BaseUsernameSignUpModel> newRepeatPasswordTextField(String id, final IModel<BaseUsernameSignUpModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.repeat.password.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.password.again.label", (Component)this);
        LabeledPasswordTextFieldPanel<String, BaseUsernameSignUpModel> pwTextField = new LabeledPasswordTextFieldPanel<String, BaseUsernameSignUpModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected PasswordTextField newPasswordTextField(String id, IModel<BaseUsernameSignUpModel> modelSuper) {
                PasswordTextField pwTextField = new PasswordTextField(id, (IModel)new PropertyModel((Object)model, "repeatPassword"));
                pwTextField.setOutputMarkupId(true);
                if (placeholderModel != null) {
                    pwTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return pwTextField;
            }
        };
        return pwTextField;
    }

    protected SigninPanel<T> newSigninPanel(String id, IModel<T> model) {
        return new SigninPanel<T>(id, model);
    }

    protected Component newUsernameTextField(String id, final IModel<T> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.username.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.username.label", (Component)this);
        LabeledTextFieldPanel nameTextField = new LabeledTextFieldPanel<String, T>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextField newTextField(String id, IModel<T> modelSuper) {
                TextField textField = new TextField(id, (IModel)new PropertyModel((Object)model, "username"));
                textField.setOutputMarkupId(true);
                textField.setRequired(true);
                if (placeholderModel != null) {
                    textField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return textField;
            }
        };
        return nameTextField;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.username = this.newUsernameTextField("username", this.getModel());
        this.add(new Component[]{this.username});
        Component[] componentArray = new Component[1];
        this.signinPanel = this.newSigninPanel("signinPanel", this.getModel());
        componentArray[0] = this.signinPanel;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.repeatPassword = this.newRepeatPasswordTextField("repeatPassword", (IModel<BaseUsernameSignUpModel>)this.getModel());
        componentArray2[0] = this.repeatPassword;
        this.add(componentArray2);
    }

    public Component getUsername() {
        return this.username;
    }

    public SigninPanel<T> getSigninPanel() {
        return this.signinPanel;
    }

    public LabeledPasswordTextFieldPanel<String, BaseUsernameSignUpModel> getRepeatPassword() {
        return this.repeatPassword;
    }
}

