/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.report;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.report.Effects;
import de.alpharogroup.wicket.components.report.ReportThrowableModelBean;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public abstract class ReportThrowablePanel
extends BasePanel<ReportThrowableModelBean> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)ReportThrowablePanel.class.getName());
    private Label header;
    private Form<?> form;
    private LabeledTextAreaPanel<String, ReportThrowableModelBean> description;
    private Button submitButton;
    private HiddenField<String> stackTrace;
    private MultiLineLabel toReplace;
    private ReportThrowableModelBean reportThrowableModel;

    public ReportThrowablePanel(String id, IModel<ReportThrowableModelBean> model) {
        super(id, model);
        this.reportThrowableModel = (ReportThrowableModelBean)model.getObject();
    }

    protected LabeledTextAreaPanel<String, ReportThrowableModelBean> newDescription(String id, IModel<ReportThrowableModelBean> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"description.label", (Component)this, (String)"Please provide here any useful information");
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.description.label", (Component)this, (String)"Enter here any useful information");
        LabeledTextAreaPanel<String, ReportThrowableModelBean> description = new LabeledTextAreaPanel<String, ReportThrowableModelBean>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextArea<String> newTextArea(String id, IModel<ReportThrowableModelBean> model) {
                TextArea textArea = super.newTextArea(id, model);
                if (placeholderModel != null) {
                    textArea.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return super.newTextArea(id, model);
            }
        };
        return description;
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected Label newHeaderLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected HiddenField<String> newHiddenField(String id, IModel<String> model) {
        return ComponentFactory.newHiddenField(id, model);
    }

    protected Button newSubmitButton(String id) {
        return new Button(id){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                ReportThrowablePanel.this.onSubmitError(null);
            }
        };
    }

    protected MultiLineLabel newToReplace(String id, IModel<String> model) {
        MultiLineLabel multiLineLabel = ComponentFactory.newMultiLineLabel(id, model);
        return multiLineLabel;
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.header = this.newHeaderLabel("header", (IModel<String>)ResourceModelFactory.newResourceModel((String)"header.label", (Component)this, (String)"Upps! An error occured."));
        componentArray[0] = this.header;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.form = this.newForm("form", this.getModel());
        componentArray2[0] = this.form;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.description = this.newDescription("description", (IModel<ReportThrowableModelBean>)this.getModel());
        componentArray3[0] = this.description;
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.toReplace = this.newToReplace("toReplace", (IModel<String>)Model.of((Serializable)((Object)"")));
        componentArray4[0] = this.toReplace;
        this.form.add(componentArray4);
        AjaxLink<Void> link = new AjaxLink<Void>("link"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ReportThrowablePanel.this.toReplace.setDefaultModelObject((Object)ReportThrowablePanel.this.reportThrowableModel.getStackTrace());
                Effects.replace(target, (Component)ReportThrowablePanel.this.toReplace);
            }
        };
        this.form.add(new Component[]{link});
        Component[] componentArray5 = new Component[1];
        this.submitButton = this.newSubmitButton("submitButton");
        componentArray5[0] = this.submitButton;
        this.form.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.stackTrace = this.newHiddenField("stackTrace", (IModel<String>)PropertyModel.of((Object)this.getModel(), (String)"stackTrace"));
        componentArray6[0] = this.stackTrace;
        this.form.add(componentArray6);
        LOGGER.error((Object)this.reportThrowableModel.getStackTrace());
    }

    protected abstract void onSubmitError(AjaxRequestTarget var1);

    public Label getHeader() {
        return this.header;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public LabeledTextAreaPanel<String, ReportThrowableModelBean> getDescription() {
        return this.description;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    public HiddenField<String> getStackTrace() {
        return this.stackTrace;
    }

    public MultiLineLabel getToReplace() {
        return this.toReplace;
    }
}

