/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.listview;

import de.alpharogroup.wicket.base.BasePanel;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Args;

public abstract class DataViewPanel<T extends Serializable>
extends BasePanel<List<T>> {
    private static final long serialVersionUID = 1L;
    private final DataView<T> dataView;

    public DataViewPanel(String id, IModel<List<T>> model) {
        super(id, (IModel)Args.notNull(model, (String)"model"));
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
        Component[] componentArray = new Component[1];
        this.dataView = this.newDataView("dataView", this.newDataProvider(model));
        componentArray[0] = this.dataView;
        this.add(componentArray);
    }

    public DataViewPanel(String id, List<T> list) {
        this(id, (IModel<List<T>>)new ListModel(list));
    }

    protected abstract IDataProvider<T> newDataProvider(IModel<List<T>> var1);

    protected DataView<T> newDataView(String id, IDataProvider<T> dataProvider) {
        DataView dataView = new DataView<T>(id, dataProvider){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<T> item) {
                item.add(new Component[]{DataViewPanel.this.newListComponent("item", item)});
            }
        };
        dataView.setItemsPerPage(this.newItemsPerPage());
        dataView.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        return dataView;
    }

    protected long newItemsPerPage() {
        return 10L;
    }

    protected abstract Component newListComponent(String var1, Item<T> var2);

    public DataView<T> getDataView() {
        return this.dataView;
    }
}

