/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.labeled;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.model.IModel;

public abstract class LabeledFormComponentPanel<T, M>
extends FormComponentPanel<M> {
    private static final long serialVersionUID = 1L;
    protected Component label;
    protected ComponentFeedbackPanel feedback;

    public LabeledFormComponentPanel(String id, IModel<M> model, IModel<String> labelModel) {
        super(id, model);
        this.setLabel(labelModel);
    }

    public void convertInput() {
        Object modelObject = this.getModel().getObject();
        this.setConvertedInput(modelObject);
    }

    public abstract FormComponent<T> getFormComponent();

    public String getInput() {
        return this.getFormComponent().getInput();
    }

    public Component getLabelComponent() {
        return this.label;
    }

    protected ComponentFeedbackPanel newComponentFeedbackPanel(String id, Component filter) {
        return ComponentFactory.newComponentFeedbackPanel(id, filter);
    }

    protected Component newLabel(String id, String forId, IModel<String> model) {
        return ComponentFactory.newLabel(id, forId, model);
    }

    protected void onBeforeRender() {
        if (this.isRequired()) {
            this.getFormComponent().add(new Behavior[]{new AttributeModifier("required", (Serializable)((Object)"required"))});
        }
        this.getFormComponent().setRequired(this.isRequired());
        super.onBeforeRender();
    }

    protected void onModelChanged() {
        super.onModelChanged();
        this.getFormComponent().modelChanged();
    }

    protected void onModelChanging() {
        super.onModelChanging();
        this.getFormComponent().modelChanging();
    }

    public ComponentFeedbackPanel getFeedback() {
        return this.feedback;
    }
}

