/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.textfield;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.label.LabeledLabelPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import de.alpharogroup.wicket.components.swap.ModeContext;
import de.alpharogroup.wicket.components.swap.SwapComponentsFragmentPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class EditableTextField<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private ModeContext modeContext = ModeContext.EDIT_MODE;
    private SwapComponentsFragmentPanel<T> swapPanel;
    private final IModel<String> labelModel;

    public static <T> EditableTextField<T> of(String id, IModel<T> model, IModel<String> labelModel) {
        return EditableTextField.of(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public static <T> EditableTextField<T> of(String id, IModel<T> model, IModel<String> labelModel, ModeContext modeContext) {
        EditableTextField<T> editableTextField = new EditableTextField<T>(id, model, labelModel, modeContext);
        return editableTextField;
    }

    public EditableTextField(String id, IModel<T> model, IModel<String> labelModel) {
        this(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public EditableTextField(String id, IModel<T> model, IModel<String> labelModel, ModeContext modeContext) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.labelModel = labelModel;
        this.modeContext = modeContext;
    }

    public boolean isEditable() {
        return this.modeContext.equals((Object)ModeContext.EDIT_MODE);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.swapPanel = new SwapComponentsFragmentPanel<T>("swapPanel", this.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newEditComponent(String id, IModel<T> model) {
                return new LabeledTextFieldPanel<String, T>(id, model, EditableTextField.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected TextField<String> newTextField(String id, IModel<T> model) {
                        return ComponentFactory.newTextField(id, new PropertyModel(model.getObject(), EditableTextField.this.getId()));
                    }
                };
            }

            @Override
            protected Component newViewComponent(String id, IModel<T> model) {
                return new LabeledLabelPanel<T>(id, model, EditableTextField.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Label newViewableLabel(String id, IModel<T> model) {
                        PropertyModel viewableLabelModel = new PropertyModel(model, EditableTextField.this.getId());
                        return ComponentFactory.newLabel(id, viewableLabelModel);
                    }
                };
            }
        };
        componentArray[0] = this.swapPanel;
        this.add(componentArray);
    }

    public void swap() {
        this.modeContext = this.modeContext.equals((Object)ModeContext.VIEW_MODE) ? ModeContext.EDIT_MODE : ModeContext.VIEW_MODE;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public void setModeContext(ModeContext modeContext) {
        this.modeContext = modeContext;
    }

    public SwapComponentsFragmentPanel<T> getSwapPanel() {
        return this.swapPanel;
    }

    public IModel<String> getLabelModel() {
        return this.labelModel;
    }
}

