/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.textarea;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.label.LabeledMultiLineLabelPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.swap.ModeContext;
import de.alpharogroup.wicket.components.swap.SwapComponentsFragmentPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class EditableTextArea<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private ModeContext modeContext = ModeContext.EDIT_MODE;
    private SwapComponentsFragmentPanel<T> swapPanel;
    private final IModel<String> labelModel;

    public static <T> EditableTextArea<T> of(String id, IModel<T> model, IModel<String> labelModel) {
        return EditableTextArea.of(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public static <T> EditableTextArea<T> of(String id, IModel<T> model, IModel<String> labelModel, ModeContext modeContext) {
        EditableTextArea<T> editableTextArea = new EditableTextArea<T>(id, model, labelModel, modeContext);
        return editableTextArea;
    }

    public EditableTextArea(String id, IModel<T> model, IModel<String> labelModel) {
        this(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public EditableTextArea(String id, IModel<T> model, IModel<String> labelModel, ModeContext modeContext) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.labelModel = labelModel;
        this.modeContext = modeContext;
    }

    public boolean isEditable() {
        return this.modeContext.equals((Object)ModeContext.EDIT_MODE);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.swapPanel = new SwapComponentsFragmentPanel<T>("swapPanel", this.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newEditComponent(String id, IModel<T> model) {
                return new LabeledTextAreaPanel<String, T>(id, model, EditableTextArea.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected TextArea<String> newTextArea(String id, IModel<T> model) {
                        PropertyModel textAreaModel = new PropertyModel(model.getObject(), EditableTextArea.this.getId());
                        return ComponentFactory.newTextArea(id, textAreaModel);
                    }
                };
            }

            @Override
            protected Component newViewComponent(String id, IModel<T> model) {
                return new LabeledMultiLineLabelPanel<T>(id, model, EditableTextArea.this.getLabelModel()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected MultiLineLabel newMultiLineLabelLabel(String id, IModel<T> model) {
                        PropertyModel viewableLabelModel = new PropertyModel(model.getObject(), EditableTextArea.this.getId());
                        return ComponentFactory.newMultiLineLabel(id, viewableLabelModel);
                    }
                };
            }
        };
        componentArray[0] = this.swapPanel;
        this.add(componentArray);
    }

    public void swap() {
        this.modeContext = this.modeContext.equals((Object)ModeContext.VIEW_MODE) ? ModeContext.EDIT_MODE : ModeContext.VIEW_MODE;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public void setModeContext(ModeContext modeContext) {
        this.modeContext = modeContext;
    }

    public SwapComponentsFragmentPanel<T> getSwapPanel() {
        return this.swapPanel;
    }

    public IModel<String> getLabelModel() {
        return this.labelModel;
    }
}

