/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.checkbox;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.ComponentFinder;
import de.alpharogroup.wicket.components.labeled.checkbox.LabeledCheckboxPanel;
import de.alpharogroup.wicket.components.labeled.label.LabeledLabelPanel;
import de.alpharogroup.wicket.components.swap.ModeContext;
import de.alpharogroup.wicket.components.swap.SwapComponentsFragmentPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;

public class EditableCheckbox
extends BasePanel<Boolean> {
    private static final long serialVersionUID = 1L;
    private ModeContext modeContext = ModeContext.VIEW_MODE;
    private SwapComponentsFragmentPanel<Boolean> swapPanel;
    private final IModel<String> labelModel;
    private Label label;
    private CheckBox checkbox;

    public EditableCheckbox(String id, IModel<Boolean> model, IModel<String> labelModel) {
        this(id, model, labelModel, ModeContext.EDIT_MODE);
    }

    public EditableCheckbox(String id, IModel<Boolean> model, IModel<String> labelModel, ModeContext modeContext) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.labelModel = labelModel;
        this.modeContext = modeContext;
    }

    public boolean isEditable() {
        return this.modeContext.equals((Object)ModeContext.EDIT_MODE);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.swapPanel = new SwapComponentsFragmentPanel<Boolean>("swapPanel", this.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Component newEditComponent(String id, IModel<Boolean> model) {
                return new LabeledCheckboxPanel(id, model, EditableCheckbox.this.getLabelModel());
            }

            @Override
            protected Component newViewComponent(String id, IModel<Boolean> model) {
                return new LabeledLabelPanel<Boolean>(id, model, EditableCheckbox.this.getLabelModel());
            }
        };
        componentArray[0] = this.swapPanel;
        this.add(componentArray);
        if (this.modeContext.equals((Object)ModeContext.EDIT_MODE)) {
            this.swapPanel.onSwapToEdit(ComponentFinder.findOrCreateNewAjaxRequestTarget(), null);
        }
    }

    public void swap() {
        this.modeContext = this.modeContext.equals((Object)ModeContext.VIEW_MODE) ? ModeContext.EDIT_MODE : ModeContext.VIEW_MODE;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }

    public void setModeContext(ModeContext modeContext) {
        this.modeContext = modeContext;
    }

    public SwapComponentsFragmentPanel<Boolean> getSwapPanel() {
        return this.swapPanel;
    }

    public IModel<String> getLabelModel() {
        return this.labelModel;
    }

    public Label getLabel() {
        return this.label;
    }

    public CheckBox getCheckbox() {
        return this.checkbox;
    }
}

