/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors.models;

import de.alpharogroup.wicket.base.util.ComponentFinder;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Args;

public class ListModelUpdateBehavior<T extends Serializable>
extends Behavior {
    private static final long serialVersionUID = 1L;
    private ListModel<T> model;
    private List<T> previousModelObject;

    public static <T extends Serializable> ListModelUpdateBehavior<T> of(ListModel<T> model) {
        return new ListModelUpdateBehavior<T>(model);
    }

    public ListModelUpdateBehavior(ListModel<T> model) {
        this.model = (ListModel)Args.notNull(model, (String)"model");
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupPlaceholderTag(true);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.previousModelObject = (List)this.model.getObject();
    }

    public void onEvent(Component component, IEvent<?> event) {
        super.onEvent(component, event);
        List currentModelObject = (List)this.model.getObject();
        if (!Objects.equals(currentModelObject, this.previousModelObject)) {
            this.previousModelObject = currentModelObject;
            component.modelChanging();
            component.modelChanged();
            AjaxRequestTarget ajaxRequestTarget = ComponentFinder.findAjaxRequestTarget();
            if (ajaxRequestTarget != null) {
                ajaxRequestTarget.add(new Component[]{component});
            }
        }
    }
}

