/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.lang.Args;
import org.odlabs.wiquery.core.javascript.ChainableStatement;
import org.odlabs.wiquery.core.javascript.JsStatement;

public class JqueryStatementsBehavior
extends Behavior {
    protected static final Logger LOGGER = Logger.getLogger((String)JqueryStatementsBehavior.class.getName());
    private static final long serialVersionUID = 1L;
    private List<ChainableStatement> chainableStatement;
    private CharSequence renderedStatement;
    private boolean rendered;

    public JqueryStatementsBehavior() {
        this.chainableStatement = new ArrayList<ChainableStatement>();
    }

    public JqueryStatementsBehavior(List<ChainableStatement> chainableStatements) {
        Args.notNull(chainableStatements, (String)"chainableStatement");
        this.chainableStatement = chainableStatements;
    }

    public JqueryStatementsBehavior add(ChainableStatement chainableStatement) {
        this.chainableStatement.add(chainableStatement);
        return this;
    }

    public CharSequence newRenderedStatement(Component component) {
        JsStatement statement;
        if (component != null) {
            component.setOutputMarkupId(true);
            statement = new JsStatement().$(component);
        } else {
            statement = new JsStatement();
        }
        for (ChainableStatement defaultChainableStatement : this.chainableStatement) {
            statement.chain(defaultChainableStatement);
        }
        this.renderedStatement = statement.render();
        this.rendered = true;
        return this.renderedStatement;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        CharSequence renderedStatement = this.newRenderedStatement(component);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)renderedStatement));
    }

    public CharSequence getRenderedStatement() {
        return this.renderedStatement;
    }

    public boolean isRendered() {
        return this.rendered;
    }
}

