/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.util.lang.Args;

public class JavascriptAppenderBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final JavascriptBindEvent DEFAULT_BIND_EVENT = JavascriptBindEvent.ONDOMREADY;
    private String target = "window";
    private String event = "click";
    private JavascriptBindEvent bindEvent = this.DEFAULT_BIND_EVENT;
    private final String id;
    private final CharSequence javascript;

    public static JavascriptAppenderBehavior of(CharSequence javascript) {
        return new JavascriptAppenderBehavior(javascript);
    }

    public static JavascriptAppenderBehavior of(CharSequence javascript, JavascriptBindEvent bindEvent) {
        return new JavascriptAppenderBehavior(javascript, bindEvent);
    }

    public static JavascriptAppenderBehavior of(String id, CharSequence javascript) {
        return new JavascriptAppenderBehavior(id, javascript);
    }

    public static JavascriptAppenderBehavior of(String id, CharSequence javascript, JavascriptBindEvent bindEvent) {
        return new JavascriptAppenderBehavior(id, javascript, bindEvent);
    }

    public JavascriptAppenderBehavior(CharSequence javascript) {
        this(String.valueOf(UUID.randomUUID()), javascript);
    }

    public JavascriptAppenderBehavior(CharSequence javascript, JavascriptBindEvent bindEvent) {
        this(null, javascript, bindEvent);
    }

    public JavascriptAppenderBehavior(String id, CharSequence javascript) {
        this(id, javascript, null);
    }

    public JavascriptAppenderBehavior(String id, CharSequence javascript, JavascriptBindEvent bindEvent) {
        this.javascript = (CharSequence)Args.notNull((Object)javascript, (String)"javascript");
        if (bindEvent != null) {
            this.bindEvent = bindEvent;
        }
        this.id = id == null ? String.valueOf(UUID.randomUUID()) : id;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        switch (this.bindEvent) {
            case ONDOMREADY: {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.javascript));
                break;
            }
            case ONEVENT: {
                response.render((HeaderItem)OnEventHeaderItem.forScript((String)this.target, (String)this.event, (CharSequence)this.javascript));
                break;
            }
            case ONLOAD: {
                response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.javascript));
                break;
            }
            default: {
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.javascript, (String)this.id));
            }
        }
    }

    public static JavascriptAppenderBehaviorBuilder builder() {
        return new JavascriptAppenderBehaviorBuilder();
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setBindEvent(JavascriptBindEvent bindEvent) {
        this.bindEvent = bindEvent;
    }

    public static class JavascriptAppenderBehaviorBuilder {
        private String id;
        private CharSequence javascript;
        private JavascriptBindEvent bindEvent;

        JavascriptAppenderBehaviorBuilder() {
        }

        public JavascriptAppenderBehaviorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JavascriptAppenderBehaviorBuilder javascript(CharSequence javascript) {
            this.javascript = javascript;
            return this;
        }

        public JavascriptAppenderBehaviorBuilder bindEvent(JavascriptBindEvent bindEvent) {
            this.bindEvent = bindEvent;
            return this;
        }

        public JavascriptAppenderBehavior build() {
            return new JavascriptAppenderBehavior(this.id, this.javascript, this.bindEvent);
        }

        public String toString() {
            return "JavascriptAppenderBehavior.JavascriptAppenderBehaviorBuilder(id=" + this.id + ", javascript=" + this.javascript + ", bindEvent=" + (Object)((Object)this.bindEvent) + ")";
        }
    }

    public static enum JavascriptBindEvent {
        ONDOMREADY,
        ONEVENT,
        ONLOAD;

    }
}

