/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;

public class FocusRequestBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ID = FocusRequestBehavior.class.getSimpleName();
    private final boolean clearValue;
    private final int delay;

    public static FocusRequestBehavior of() {
        return new FocusRequestBehavior();
    }

    public static FocusRequestBehavior of(boolean clearValue) {
        return new FocusRequestBehavior(clearValue);
    }

    public static FocusRequestBehavior of(boolean clearValue, Integer delay) {
        return new FocusRequestBehavior(clearValue, delay);
    }

    public static FocusRequestBehavior of(Integer delay) {
        return new FocusRequestBehavior(delay);
    }

    public FocusRequestBehavior() {
        this(false);
    }

    public FocusRequestBehavior(boolean clearValue) {
        this(clearValue, 1);
    }

    public FocusRequestBehavior(boolean clearValue, Integer delay) {
        this.clearValue = clearValue;
        this.delay = delay;
    }

    public FocusRequestBehavior(Integer delay) {
        this(false, delay);
    }

    protected String newJavaScript(Component component) {
        StringBuilder sb = new StringBuilder();
        sb.append("setTimeout(function() {var component = document.getElementById(\"").append(component.getMarkupId()).append("\");");
        if (this.clearValue) {
            sb.append("component.value = \"\";");
        }
        sb.append("component.focus();");
        sb.append("component.select();");
        sb.append("}, " + this.delay + ")");
        return sb.toString();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        component.setOutputMarkupId(true);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.newJavaScript(component)));
    }
}

