/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;

public abstract class AjaxDownloadBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private boolean antiCache;

    public AjaxDownloadBehavior() {
        this(true);
    }

    public AjaxDownloadBehavior(boolean antiCache) {
        this.antiCache = antiCache;
    }

    protected abstract String getFileName();

    protected abstract IResourceStream getResourceStream();

    public void initiate(AjaxRequestTarget target) {
        String url = this.getCallbackUrl().toString();
        if (this.antiCache) {
            url = url + (url.contains("?") ? "&" : "?");
            url = url + "antiCache=" + System.currentTimeMillis();
        }
        target.appendJavaScript((CharSequence)("setTimeout(\"window.location.href='" + url + "'\", 100);"));
    }

    public void onRequest() {
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(this.getResourceStream(), this.getFileName());
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        this.getComponent().getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
    }
}

