/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util.parameter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Session;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;

public final class PageParametersExtensions {
    private static final Logger LOGGER = Logger.getLogger((String)PageParametersExtensions.class.getName());

    public static void addParameters(IRequestParameters parameters, Map<String, String[]> parameterMap) {
        Set parameterNames = parameters.getParameterNames();
        for (String parameterName : parameterNames) {
            List parameterValues = parameters.getParameterValues(parameterName);
            Object[] stringArray = new String[]{};
            if (parameterValues != null && !parameterValues.isEmpty()) {
                stringArray = new String[parameterValues.size()];
                for (int i = 0; i < parameterValues.size(); ++i) {
                    stringArray[i] = ((StringValue)parameterValues.get(i)).toString();
                }
                if (parameterMap.containsKey(parameterName)) {
                    stringArray = (String[])ArrayUtils.addAll((Object[])parameterMap.get(parameterName), (Object[])stringArray);
                }
            }
            parameterMap.put(parameterName, (String[])stringArray);
        }
    }

    public static void addToParameters(IRequestParameters parameters, Map<String, List<StringValue>> parameterMap) {
        for (String parameterName : parameters.getParameterNames()) {
            List parameterValues = parameters.getParameterValues(parameterName);
            parameterMap.put(parameterName, parameterValues);
        }
    }

    public static PageParameters copy(PageParameters source, PageParameters destination) {
        Args.notNull((Object)source, (String)"source");
        Args.notNull((Object)destination, (String)"destination");
        List namedPairs = source.getAllNamed();
        for (INamedParameters.NamedPair namedPair : namedPairs) {
            destination.add(namedPair.getKey(), (Object)namedPair.getValue());
        }
        return destination;
    }

    public static void copyToWicketSession(PageParameters source, Session session) {
        List namedPairs = source.getAllNamed();
        for (INamedParameters.NamedPair namedPair : namedPairs) {
            session.setAttribute(namedPair.getKey(), (Serializable)((Object)namedPair.getValue()));
        }
    }

    @Deprecated
    public static Integer getInteger(StringValue stringValue) {
        return PageParametersExtensions.toInteger(stringValue);
    }

    public static Map<String, List<StringValue>> getPageParametersMap(Request request) {
        HashMap<String, List<StringValue>> map = new HashMap<String, List<StringValue>>();
        PageParametersExtensions.addToParameters(request.getRequestParameters(), map);
        PageParametersExtensions.addToParameters(request.getQueryParameters(), map);
        PageParametersExtensions.addToParameters(request.getPostParameters(), map);
        return map;
    }

    public static String getParameter(PageParameters parameters, String name) {
        return PageParametersExtensions.getString(parameters.get(name));
    }

    public static String getParameter(Request request, String parameterName) {
        String parameterValue = request.getRequestParameters().getParameterValue(parameterName).toString();
        if (parameterValue == null || parameterValue.isEmpty()) {
            parameterValue = request.getPostParameters().getParameterValue(parameterName).toString();
        }
        if (parameterValue == null || parameterValue.isEmpty()) {
            parameterValue = request.getQueryParameters().getParameterValue(parameterName).toString();
        }
        if (parameterValue == null || parameterValue.isEmpty()) {
            parameterValue = request.getRequestParameters().getParameterValue(parameterName).toString();
        }
        return parameterValue;
    }

    public static String getParameter(String parameterName) {
        Request request = RequestCycle.get().getRequest();
        return PageParametersExtensions.getParameter(request, parameterName);
    }

    public static Map<String, String[]> getParameterMap() {
        Request request = RequestCycle.get().getRequest();
        return PageParametersExtensions.getParameterMap(request);
    }

    public static Map<String, String[]> getParameterMap(Request request) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        PageParametersExtensions.addParameters(request.getRequestParameters(), map);
        PageParametersExtensions.addParameters(request.getQueryParameters(), map);
        PageParametersExtensions.addParameters(request.getPostParameters(), map);
        return map;
    }

    public static String getString(StringValue value) {
        if (PageParametersExtensions.isNotNullOrEmpty(value)) {
            return value.toString();
        }
        return null;
    }

    public static final boolean isNotNullOrEmpty(StringValue stringValue) {
        return stringValue != null && !stringValue.isNull() && !stringValue.isEmpty();
    }

    public static final boolean isNullOrEmpty(StringValue stringValue) {
        return stringValue == null || stringValue.isNull() || stringValue.isEmpty();
    }

    public static Integer toInteger(StringValue stringValue) {
        Integer value = null;
        if (PageParametersExtensions.isNotNullOrEmpty(stringValue)) {
            try {
                value = stringValue.toInteger();
            }
            catch (StringValueConversionException e) {
                LOGGER.error((Object)"Error by converting the given StringValue.", (Throwable)e);
            }
        }
        return value;
    }

    public static PageParameters toPageParameters(Map<String, String> parameters) {
        PageParameters param = new PageParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            param.add(parameter.getKey(), (Object)parameter.getValue());
        }
        return param;
    }
}

