/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util.application;

import de.alpharogroup.wicket.base.util.resource.ByteArrayResourceStreamWriter;
import java.io.File;
import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.core.util.file.WebApplicationPath;
import org.apache.wicket.javascript.DefaultJavaScriptCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.JavaScriptFilteredIntoFooterHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.SecurePackageResourceGuard;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.HttpsMapper;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;
import org.apache.wicket.settings.ExceptionSettings;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.time.Duration;

public final class ApplicationExtensions {
    public static final String[] DEFAULT_PACKAGE_RESOURCE_GUARD_PATTERNS = new String[]{"UTF-8", "+*.css", "+*.png", "+*.woff2", "+*.js.map"};

    public static void addFilePatternsToPackageResourceGuard(Application application, String ... patterns) {
        IPackageResourceGuard packageResourceGuard = application.getResourceSettings().getPackageResourceGuard();
        if (packageResourceGuard instanceof SecurePackageResourceGuard) {
            SecurePackageResourceGuard guard = (SecurePackageResourceGuard)packageResourceGuard;
            for (String pattern : patterns) {
                guard.addPattern(pattern);
            }
        }
    }

    public static void addResourceFinder(WebApplication application, String resourcePath) {
        application.getResourceSettings().getResourceFinders().add(new WebApplicationPath(application.getServletContext(), resourcePath));
    }

    public static String getContextPath(WebApplication application) {
        String contextPath = application.getServletContext().getContextPath();
        if (null != contextPath && !contextPath.isEmpty()) {
            return contextPath;
        }
        return "";
    }

    public static ResourceReference getJQueryReference() {
        return ApplicationExtensions.getJQueryReference(Application.get());
    }

    public static ResourceReference getJQueryReference(Application application) {
        return application.getJavaScriptLibrarySettings().getJQueryReference();
    }

    public static String getRealPath(WebApplication application, String path) {
        String realPath = application.getServletContext().getRealPath(path);
        if (null != realPath && !realPath.isEmpty()) {
            return realPath;
        }
        return "";
    }

    public static IRequestLogger getRequestLogger() {
        return ApplicationExtensions.getRequestLogger(null);
    }

    public static IRequestLogger getRequestLogger(WebApplication webApplication) {
        IRequestLogger requestLogger;
        if (webApplication == null) {
            webApplication = (WebApplication)Application.get();
        }
        if ((requestLogger = webApplication.getRequestLogger()) == null) {
            requestLogger = new RequestLogger();
        }
        return requestLogger;
    }

    public static IResourceStream getResourceStream(final File file, final String contentType) throws IOException {
        return new ByteArrayResourceStreamWriter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            protected byte[] load() throws IOException {
                byte[] data = Files.readBytes((File)file);
                return data;
            }
        };
    }

    public static IResourceStream getResourceStream(final WebApplication application, final String path, final String contentType) throws IOException {
        return new ByteArrayResourceStreamWriter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            protected byte[] load() throws IOException {
                String realPath = ApplicationExtensions.getRealPath(application, path);
                org.apache.wicket.util.file.File file = new org.apache.wicket.util.file.File(realPath);
                byte[] data = Files.readBytes((File)file);
                return data;
            }
        };
    }

    public static void initializeSpring(WebApplication application) {
        application.getComponentInstantiationListeners().add((Object)new SpringComponentInjector(application));
    }

    public static void replaceJQueryReference(WebApplication application, String cdnjsUrl) {
        application.getJavaScriptLibrarySettings().setJQueryReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)cdnjsUrl)));
    }

    @Deprecated
    public static void setDebugSettingsForDeployment(Application application) {
        ApplicationExtensions.setDeploymentModeConfiguration(application);
    }

    public static void setDebugSettingsForDevelopment(Application application) {
        application.getDebugSettings().setComponentUseCheck(true);
        application.getDebugSettings().setOutputMarkupContainerClassName(true);
        application.getDebugSettings().setLinePreciseReportingOnAddComponentEnabled(true);
        application.getDebugSettings().setLinePreciseReportingOnNewComponentEnabled(true);
        application.getDebugSettings().setAjaxDebugModeEnabled(true);
        application.getDebugSettings().setDevelopmentUtilitiesEnabled(true);
    }

    public static void setDefaultDebugSettingsForDevelopment(WebApplication application) {
        ApplicationExtensions.setHtmlHotDeploy(application);
        ApplicationExtensions.setDebugSettingsForDevelopment((Application)application);
        ApplicationExtensions.setExceptionSettingsForDevelopment((Application)application);
        application.getResourceSettings().setThrowExceptionOnMissingResource(true);
    }

    public static void setDefaultDeploymentModeConfiguration(Application application, AbstractRequestCycleListener applicationRequestCycleListener) {
        if (applicationRequestCycleListener != null) {
            ApplicationExtensions.setExceptionSettingsForDeployment(application, applicationRequestCycleListener);
        }
        ApplicationExtensions.setDeploymentModeConfiguration(application);
    }

    public static void setDeploymentModeConfiguration(Application application) {
        application.getMarkupSettings().setStripComments(true);
        application.getResourceSettings().setResourcePollFrequency(null);
        application.getResourceSettings().setJavaScriptCompressor((IJavaScriptCompressor)new DefaultJavaScriptCompressor());
        application.getResourceSettings().setThrowExceptionOnMissingResource(false);
        application.getDebugSettings().setComponentUseCheck(false);
        application.getDebugSettings().setAjaxDebugModeEnabled(false);
        application.getDebugSettings().setDevelopmentUtilitiesEnabled(false);
        application.getDebugSettings().setOutputMarkupContainerClassName(false);
        application.getDebugSettings().setLinePreciseReportingOnAddComponentEnabled(false);
        application.getDebugSettings().setLinePreciseReportingOnNewComponentEnabled(false);
    }

    public static void setExceptionSettingsForDeployment(Application application, AbstractRequestCycleListener applicationRequestCycleListener) {
        application.getExceptionSettings().setUnexpectedExceptionDisplay(ExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
        application.getRequestCycleListeners().add((Object)applicationRequestCycleListener);
    }

    public static void setExceptionSettingsForDevelopment(Application application) {
        application.getExceptionSettings().setUnexpectedExceptionDisplay(ExceptionSettings.SHOW_EXCEPTION_PAGE);
    }

    @Deprecated
    public static void setFooterHeaderResponse(Application application, String footerFilterName) {
        ApplicationExtensions.setHeaderResponseDecorator(application, footerFilterName);
    }

    public static void setGlobalSettings(WebApplication application, int httpPort, int httpsPort, String footerFilterName, String encoding, String ... patterns) {
        application.getMarkupSettings().setDefaultMarkupEncoding(encoding);
        application.getRequestCycleSettings().setResponseRequestEncoding(encoding);
        ApplicationExtensions.setHeaderResponseDecorator((Application)application, footerFilterName);
        ApplicationExtensions.setRootRequestMapper((Application)application, httpPort, httpsPort);
        ApplicationExtensions.addFilePatternsToPackageResourceGuard((Application)application, patterns);
        application.getMarkupSettings().setStripWicketTags(true);
    }

    public static void setHeaderResponseDecorator(Application application, final String footerFilterName) {
        application.setHeaderResponseDecorator(new IHeaderResponseDecorator(){

            public IHeaderResponse decorate(IHeaderResponse response) {
                return new JavaScriptFilteredIntoFooterHeaderResponse(response, footerFilterName);
            }
        });
    }

    public static void setHtmlHotDeploy(WebApplication application) {
        application.getResourceSettings().setResourcePollFrequency(Duration.ONE_SECOND);
        String slash = "/";
        String realPath = application.getServletContext().getRealPath("/");
        if (realPath != null && !realPath.endsWith("/")) {
            realPath = realPath + "/";
        }
        String javaSourcePath = realPath + "../java";
        String resourcesPath = realPath + "../resources";
        ApplicationExtensions.addResourceFinder(application, javaSourcePath);
        ApplicationExtensions.addResourceFinder(application, resourcesPath);
    }

    public static IRequestMapper setRootRequestMapper(Application application, int httpPort, int httpsPort) {
        HttpsMapper httpsMapper = new HttpsMapper(application.getRootRequestMapper(), new HttpsConfig(httpPort, httpsPort));
        application.setRootRequestMapper((IRequestMapper)httpsMapper);
        return httpsMapper;
    }

    public static void setRootRequestMapperForDevelopment(final Application application, int httpPort, int httpsPort) {
        application.setRootRequestMapper((IRequestMapper)new HttpsMapper(application.getRootRequestMapper(), new HttpsConfig(httpPort, httpsPort)){

            protected Scheme getDesiredSchemeFor(Class<? extends IRequestablePage> pageClass) {
                if (application.getConfigurationType().equals((Object)RuntimeConfigurationType.DEVELOPMENT)) {
                    return Scheme.HTTP;
                }
                return super.getDesiredSchemeFor(pageClass);
            }
        });
    }

    @Deprecated
    public static void setSettingsForDeployment(Application application) {
        ApplicationExtensions.setDeploymentModeConfiguration(application);
    }

    private ApplicationExtensions() {
    }
}

