/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util;

import de.alpharogroup.lang.AnnotationExtensions;
import de.alpharogroup.wicket.base.util.parameter.PageParametersExtensions;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.time.Time;

public final class WicketComponentExtensions {
    public static void disableCaching(WebResponse response) {
        response.setLastModifiedTime(Time.now());
        HttpServletResponse httpServletResponse = WicketComponentExtensions.getHttpServletResponse((Response)response);
        if (httpServletResponse != null) {
            httpServletResponse.addHeader("Cache-Control", "max-age=0");
            httpServletResponse.setDateHeader("Expires", 0L);
        }
    }

    @Deprecated
    public static String getContextPath(WebApplication application) {
        String contextPath = application.getServletContext().getContextPath();
        if (null != contextPath && !contextPath.isEmpty()) {
            return contextPath;
        }
        return "";
    }

    public static Behavior getHeaderContributorForFavicon() {
        return new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)new StringHeaderItem((CharSequence)"<link type=\"image/x-icon\" rel=\"shortcut icon\" href=\"favicon.ico\" />"));
            }
        };
    }

    public static HttpServletRequest getHttpServletRequest() {
        Request request = RequestCycle.get().getRequest();
        return WicketComponentExtensions.getHttpServletRequest(request);
    }

    public static HttpServletRequest getHttpServletRequest(Request request) {
        WebRequest webRequest = (WebRequest)request;
        HttpServletRequest httpServletRequest = (HttpServletRequest)webRequest.getContainerRequest();
        return httpServletRequest;
    }

    public static HttpServletResponse getHttpServletResponse() {
        Response response = RequestCycle.get().getResponse();
        return WicketComponentExtensions.getHttpServletResponse(response);
    }

    public static HttpServletResponse getHttpServletResponse(Response response) {
        WebResponse webResponse = (WebResponse)response;
        HttpServletResponse httpServletResponse = (HttpServletResponse)webResponse.getContainerResponse();
        return httpServletResponse;
    }

    public static String getIpAddress() {
        String ipAddress = WicketComponentExtensions.getHttpServletRequest().getRemoteHost();
        return ipAddress;
    }

    @Deprecated
    public static String getParameter(Request request, String parameterName) {
        return PageParametersExtensions.getParameter(request, parameterName);
    }

    @Deprecated
    public static String getParameter(String parameterName) {
        return PageParametersExtensions.getParameter(parameterName);
    }

    @Deprecated
    public static Map<String, String[]> getParameterMap() {
        return PageParametersExtensions.getParameterMap();
    }

    @Deprecated
    public static Map<String, String[]> getParameterMap(Request request) {
        return PageParametersExtensions.getParameterMap(request);
    }

    public static String getRemoteAddr() {
        String ipAddress = WicketComponentExtensions.getHttpServletRequest().getRemoteAddr();
        return ipAddress;
    }

    public static String getRequestURL() {
        StringBuffer url = WicketComponentExtensions.getHttpServletRequest().getRequestURL();
        return url.toString();
    }

    public static boolean isHttps() {
        return WicketComponentExtensions.getHttpServletRequest().getScheme().equalsIgnoreCase("https");
    }

    public static boolean isSecure(Component component) {
        return AnnotationExtensions.isAnnotationPresentInSuperClassesOrInterfaces(component.getClass(), RequireHttps.class);
    }

    public static void setDefaultSecurityHeaders(WebResponse response) {
        WicketComponentExtensions.setSecurityFramingHeaders(response);
        WicketComponentExtensions.setSecurityTransportHeaders(response);
        WicketComponentExtensions.setSecurityXSSHeaders(response);
        WicketComponentExtensions.setSecurityCachingHeaders(response);
    }

    public static void setSecurityAccessControlHeader(WebResponse response) {
        response.setHeader("X-Permitted-Cross-Domain-Policies", "master-only");
    }

    public static void setSecurityCachingHeaders(WebResponse response) {
        response.setHeader("Cache-Control", "must-revalidate;");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
    }

    public static void setSecurityContentHeaders(WebResponse response) {
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Content-Type", "text/html;charset=utf-8");
    }

    public static void setSecurityCookieHeaders(WebResponse response) {
        response.setHeader("Set-Cookie", "secure;httponly;");
    }

    public static void setSecurityFramingHeaders(WebResponse response) {
        response.setHeader("X-Frame-Options", "sameorigin");
    }

    public static void setSecurityTransportHeaders(WebResponse response) {
        response.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
    }

    public static void setSecurityXSSHeaders(WebResponse response) {
        response.setHeader("X-XSS-Protection", "1; mode=block");
    }

    public static String toAbsolutePath(String relativePagePath) {
        HttpServletRequest req = (HttpServletRequest)((WebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        return RequestUtils.toAbsolutePath((String)req.getRequestURL().toString(), (String)relativePagePath);
    }

    @Deprecated
    public static PageParameters toPageParameters(Map<String, String> parameters) {
        return PageParametersExtensions.toPageParameters(parameters);
    }
}

