/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util;

import de.alpharogroup.lang.ClassExtensions;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.RequestSettingRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;

public final class ComponentFinder {
    public static AjaxRequestTarget findAjaxRequestTarget() {
        return (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
    }

    public static AjaxRequestTarget findOrCreateNewAjaxRequestTarget() {
        return ComponentFinder.findOrCreateNewAjaxRequestTarget(WebApplication.get(), ComponentFinder.getCurrentPage());
    }

    public static AjaxRequestTarget findOrCreateNewAjaxRequestTarget(WebApplication application, Page page) {
        AjaxRequestTarget target = ComponentFinder.findAjaxRequestTarget();
        if (target != null) {
            return target;
        }
        return ComponentFinder.newAjaxRequestTarget(application, page);
    }

    public static Component findParent(Component childComponent, Class<? extends Component> parentClass) {
        return ComponentFinder.findParent(childComponent, parentClass, true);
    }

    public static Component findParent(Component childComponent, Class<? extends Component> parentClass, boolean byClassname) {
        MarkupContainer parent;
        for (parent = childComponent.getParent(); parent != null && !parent.getClass().equals(parentClass); parent = parent.getParent()) {
        }
        if (parent == null && byClassname) {
            return ComponentFinder.findParentByClassname(childComponent, parentClass);
        }
        return parent;
    }

    public static Component findParentByClassname(Component childComponent, Class<? extends Component> parentClass) {
        MarkupContainer parent;
        for (parent = childComponent.getParent(); parent != null && !ClassExtensions.equalsByClassName(parentClass, parent.getClass()); parent = parent.getParent()) {
        }
        return parent;
    }

    public static Component findParentForm(Component childComponent) {
        Component parent = ComponentFinder.findParent(childComponent, Form.class);
        if (parent != null && parent.getClass().equals(Form.class)) {
            return parent;
        }
        return null;
    }

    public static Page getCurrentPage() {
        IRequestHandler requestHandler = RequestCycle.get().getActiveRequestHandler();
        Page page = ComponentFinder.getPage(requestHandler);
        if (page != null) {
            return page;
        }
        if (requestHandler instanceof RequestSettingRequestHandler) {
            RequestSettingRequestHandler requestSettingRequestHandler = (RequestSettingRequestHandler)requestHandler;
            return ComponentFinder.getPage(requestSettingRequestHandler.getDelegateHandler());
        }
        return null;
    }

    public static Page getPage(IRequestHandler requestHandler) {
        if (requestHandler instanceof IPageRequestHandler) {
            IPageRequestHandler pageRequestHandler = (IPageRequestHandler)requestHandler;
            return (Page)pageRequestHandler.getPage();
        }
        return null;
    }

    public static AjaxRequestTarget newAjaxRequestTarget(WebApplication application, Page page) {
        return application.newAjaxRequestTarget(page);
    }
}

