/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.application.plugins;

import de.alpharogroup.wicket.base.util.WicketComponentExtensions;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class SecuritySettingsPlugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<SecuritySettingsPlugin> SECURITY_SETTINGS_PLUGIN_KEY = new MetaDataKey<SecuritySettingsPlugin>(){
        private static final long serialVersionUID = 1L;
    };

    public static SecuritySettingsPlugin get() {
        Application app = Application.get();
        if (null == app) {
            throw new IllegalStateException("No wicket application is bound to the current thread.");
        }
        SecuritySettingsPlugin plugin = (SecuritySettingsPlugin)app.getMetaData(SECURITY_SETTINGS_PLUGIN_KEY);
        if (null == plugin) {
            String pluginClassName = SecuritySettingsPlugin.class.getSimpleName();
            throw new IllegalStateException("A " + pluginClassName + " has not been installed in this Wicket application. You have to call " + pluginClassName + ".install() in your application init().");
        }
        return plugin;
    }

    public SecuritySettingsPlugin install(WebApplication application) {
        Args.notNull((Object)application, (String)"app");
        this.onConfigure(application);
        return this;
    }

    protected void onConfigure(WebApplication application) {
        this.set((Application)application, this);
        application.getRequestCycleListeners().add((Object)new AbstractRequestCycleListener(){

            public void onBeginRequest(RequestCycle cycle) {
                super.onBeginRequest(cycle);
                WebResponse response = (WebResponse)cycle.getResponse();
                WicketComponentExtensions.setSecurityFramingHeaders(response);
                WicketComponentExtensions.setSecurityTransportHeaders(response);
                WicketComponentExtensions.setSecurityXSSHeaders(response);
                WicketComponentExtensions.setSecurityCachingHeaders(response);
            }
        });
    }

    public void set(Application app, SecuritySettingsPlugin plugin) {
        app.setMetaData(SECURITY_SETTINGS_PLUGIN_KEY, (Object)plugin);
    }
}

