/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util.url;

import de.alpharogroup.wicket.base.util.WicketComponentExtensions;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class WicketUrlExtensions {
    public static <C extends Page> String absoluteUrlFor(Class<C> page) {
        return WicketUrlExtensions.absoluteUrlFor(page, null, false);
    }

    public static <C extends Page> String absoluteUrlFor(Class<C> page, boolean withServerPort) {
        return WicketUrlExtensions.absoluteUrlFor(page, null, withServerPort);
    }

    public static <C extends Page> String absoluteUrlFor(Class<C> page, PageParameters parameters, boolean withServerPort) {
        StringBuilder url = new StringBuilder();
        url.append(WicketUrlExtensions.getDomainUrl(withServerPort));
        url.append(WicketUrlExtensions.getBaseUrl(page, parameters).canonical().toString());
        return url.toString();
    }

    public static Url getBaseUrl() {
        return RequestCycle.get().getUrlRenderer().getBaseUrl();
    }

    public static Url getBaseUrl(Class<? extends Page> pageClass) {
        return WicketUrlExtensions.getBaseUrl(pageClass, null);
    }

    public static Url getBaseUrl(Class<? extends Page> pageClass, PageParameters parameters) {
        return RequestCycle.get().mapUrlFor(pageClass, parameters);
    }

    public static Url getBaseUrl(Page page) {
        return WicketUrlExtensions.getBaseUrl(page.getPageClass());
    }

    public static Url getCanonicalPageUrl(Class<? extends Page> pageClass) {
        return WicketUrlExtensions.getCanonicalPageUrl(pageClass, null);
    }

    public static Url getCanonicalPageUrl(Class<? extends Page> pageClass, PageParameters parameters) {
        return WicketUrlExtensions.getPageUrl(pageClass, parameters).canonical();
    }

    public static String getContextPath() {
        return RequestCycle.get().getRequest().getContextPath();
    }

    public static String getContextPath(Page page) {
        return page.getRequest().getContextPath();
    }

    public static String getDomainUrl() {
        return WicketUrlExtensions.getDomainUrl(true);
    }

    public static String getDomainUrl(boolean withServerPort) {
        return WicketUrlExtensions.getDomainUrl(withServerPort, true);
    }

    public static String getDomainUrl(boolean withServerPort, boolean withSlashAtTheEnd) {
        return WicketUrlExtensions.getDomainUrl(false, withServerPort, withSlashAtTheEnd);
    }

    public static String getDomainUrl(boolean ssl, boolean withServerPort, boolean withSlashAtTheEnd) {
        return WicketUrlExtensions.newDomainUrl(ssl ? Scheme.HTTPS.urlName() : Scheme.HTTP.urlName(), WicketUrlExtensions.getServerName(), WicketComponentExtensions.getHttpServletRequest().getServerPort(), withServerPort, withSlashAtTheEnd);
    }

    public static String getLocalName() {
        return WicketComponentExtensions.getHttpServletRequest().getLocalName();
    }

    public static Url getPageUrl(Class<? extends Page> pageClass) {
        return WicketUrlExtensions.getPageUrl(pageClass, null);
    }

    public static Url getPageUrl(Class<? extends Page> pageClass, PageParameters parameters) {
        String url = RequestCycle.get().urlFor(pageClass, parameters).toString();
        return Url.parse((CharSequence)url);
    }

    public static Url getPageUrl(Page page) {
        return WicketUrlExtensions.getPageUrl(page.getPageClass());
    }

    public static Url getPageUrl(Page page, PageParameters parameters) {
        return WicketUrlExtensions.getPageUrl(page.getPageClass(), parameters);
    }

    public static String getServerName() {
        return WicketComponentExtensions.getHttpServletRequest().getServerName();
    }

    public static String getUrlAsString(Class<? extends Page> pageClass) {
        Url pageUrl = WicketUrlExtensions.getPageUrl(pageClass);
        Url url = WicketUrlExtensions.getBaseUrl(pageClass);
        url.resolveRelative(pageUrl);
        String contextPath = WicketUrlExtensions.getContextPath();
        return String.format("%s/%s", contextPath, url);
    }

    public static String getUrlAsString(Page page) {
        return WicketUrlExtensions.getUrlAsString(page.getPageClass());
    }

    public static String newDomainUrl(String scheme, String domainName, int port, boolean withServerPort, boolean withSlashAtTheEnd) {
        StringBuilder domainUrl = new StringBuilder();
        domainUrl.append(scheme);
        domainUrl.append("://");
        domainUrl.append(domainName);
        if (withServerPort) {
            domainUrl.append(":");
            domainUrl.append(port);
        }
        if (withSlashAtTheEnd) {
            domainUrl.append("/");
        }
        return domainUrl.toString();
    }

    public static String toBaseUrl() {
        return WicketUrlExtensions.getBaseUrl().canonical().toString();
    }

    public static String toBaseUrl(Class<? extends Page> pageClass) {
        return WicketUrlExtensions.getBaseUrl(pageClass).canonical().toString();
    }

    public static String toBaseUrl(Class<? extends Page> pageClass, PageParameters parameters) {
        return WicketUrlExtensions.getBaseUrl(pageClass, parameters).canonical().toString();
    }
}

