/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util.seo;

import java.util.HashSet;
import java.util.Set;

public final class BotAgentInspector {
    private static final Set<String> BOT_AGENTS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("googlebot");
            this.add("msnbot");
            this.add("slurp");
            this.add("jeeves");
            this.add("appie");
            this.add("architext");
            this.add("ferret");
            this.add("harvest");
            this.add("htdig");
            this.add("linkwalker");
            this.add("lycos_");
            this.add("moget");
            this.add("muscatferret");
            this.add("myweb");
            this.add("nomad");
            this.add("scooter");
            this.add("yahoo!\\sslurp\\schina");
            this.add("antibot");
            this.add("bruinbot");
            this.add("digout4u");
            this.add("echo!");
            this.add("ia_archiver");
            this.add("jennybot");
            this.add("mercator");
            this.add("netcraft");
            this.add("petersnews");
            this.add("unlost_web_crawler");
            this.add("voila");
            this.add("webbase");
            this.add("webcollage");
            this.add("cfetch");
            this.add("zyborg");
            this.add("wisenutbot");
            this.add("robot");
            this.add("spider");
        }
    };
    private static final Set<String> NO_BOT_AGENTS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("firefox");
            this.add("msie");
            this.add("opera");
            this.add("netscape");
            this.add("safari");
            this.add("chrome");
        }
    };

    public static boolean isAgent(String agent) {
        if (agent != null) {
            String lowerAgent = agent.toLowerCase();
            for (String noBot : NO_BOT_AGENTS) {
                if (!lowerAgent.contains(noBot)) continue;
                return false;
            }
            for (String bot : BOT_AGENTS) {
                if (!lowerAgent.contains(bot)) continue;
                return true;
            }
        }
        return false;
    }

    private BotAgentInspector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

