/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util.resource;

import de.alpharogroup.resourcebundle.locale.ResourceBundleKey;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public final class ResourceModelFactory {
    public static IModel<String> newResourceModel(ResourceBundleKey resourceBundleKey) {
        String resourceKey = resourceBundleKey.getKey();
        IModel<String> resourceModel = ResourceModelFactory.newResourceModel(resourceKey, resourceBundleKey.getParameters(), null, resourceBundleKey.getDefaultValue());
        return resourceModel;
    }

    public static IModel<String> newResourceModel(ResourceBundleKey resourceBundleKey, Component component) {
        String resourceKey = resourceBundleKey.getKey();
        IModel<String> resourceModel = ResourceModelFactory.newResourceModel(resourceKey, resourceBundleKey.getParameters(), component, resourceBundleKey.getDefaultValue());
        return resourceModel;
    }

    public static IModel<String> newResourceModel(ResourceBundleKey resourceBundleKey, Component component, IModel<?> model) {
        IModel<String> resourceModel = ResourceModelFactory.newResourceModel(resourceBundleKey.getKey(), component, model, resourceBundleKey.getDefaultValue(), resourceBundleKey.getParameters());
        return resourceModel;
    }

    public static IModel<String> newResourceModel(ResourceBundleKey resourceBundleKey, IModel<?> model) {
        IModel<String> resourceModel = ResourceModelFactory.newResourceModel(resourceBundleKey.getKey(), null, model, resourceBundleKey.getDefaultValue(), resourceBundleKey.getParameters());
        return resourceModel;
    }

    public static IModel<String> newResourceModel(String resourceBundleKey) {
        return ResourceModelFactory.newResourceModel(ResourceBundleKey.builder().key(resourceBundleKey).build());
    }

    public static IModel<String> newResourceModel(String resourceKey, Component component) {
        return ResourceModelFactory.newResourceModel(resourceKey, component, null, "", new Object[0]);
    }

    public static IModel<String> newResourceModel(String resourceKey, Component component, IModel<?> model, Object ... parameters) {
        return ResourceModelFactory.newResourceModel(resourceKey, component, model, null, parameters);
    }

    public static IModel<String> newResourceModel(String resourceKey, Component component, IModel<?> model, String defaultValue, Object ... parameters) {
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null || !(parameters[i] instanceof ResourceBundleKey)) continue;
                ResourceBundleKey parameter = (ResourceBundleKey)parameters[i];
                IModel<String> parameterValue = ResourceModelFactory.newResourceModel(parameter, component);
                parameters[i] = parameterValue.getObject();
            }
        }
        return new StringResourceModel(resourceKey, component, model).setDefaultValue(defaultValue).setParameters(parameters);
    }

    public static IModel<String> newResourceModel(String resourceKey, Component component, Object ... parameters) {
        return ResourceModelFactory.newResourceModel(resourceKey, component, null, null, parameters);
    }

    public static IModel<String> newResourceModel(String resourceKey, Component component, String defaultValue) {
        return ResourceModelFactory.newResourceModel(resourceKey, component, null, defaultValue, new Object[0]);
    }

    public static IModel<String> newResourceModel(String resourceKey, IModel<?> model, Object ... parameters) {
        return ResourceModelFactory.newResourceModel(resourceKey, null, model, null, parameters);
    }

    public static IModel<String> newResourceModel(String resourceKey, IModel<?> model, String defaultValue, Object ... parameters) {
        return ResourceModelFactory.newResourceModel(resourceKey, null, model, defaultValue, parameters);
    }

    public static IModel<String> newResourceModel(String resourceKey, Object[] parameters, Component component, String defaultValue) {
        if (parameters != null && parameters.length > 0) {
            if (defaultValue != null && !defaultValue.isEmpty()) {
                return ResourceModelFactory.newResourceModel(resourceKey, defaultValue, component, parameters);
            }
            return ResourceModelFactory.newResourceModel(resourceKey, component, parameters);
        }
        if (defaultValue != null && !defaultValue.isEmpty()) {
            return ResourceModelFactory.newResourceModel(resourceKey, component, defaultValue);
        }
        return ResourceModelFactory.newResourceModel(resourceKey, component);
    }

    public static IModel<String> newResourceModel(String resourceKey, String defaultValue, Component component, Object ... parameters) {
        return ResourceModelFactory.newResourceModel(resourceKey, component, null, null, parameters);
    }
}

