/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util;

import de.alpharogroup.wicket.base.util.WicketComponentExtensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.WebApplication;

public class SessionExtensions {
    public static HttpSession getHttpSession() {
        HttpSession session;
        HttpServletRequest request = WicketComponentExtensions.getHttpServletRequest();
        if (request != null && (session = request.getSession(false)) != null) {
            return session;
        }
        return null;
    }

    public static List<IRequestLogger.SessionData> getLiveSessions() {
        return new ArrayList<IRequestLogger.SessionData>(Arrays.asList(SessionExtensions.getRequestLogger().getLiveSessions()));
    }

    public static Integer getPeakSessions() {
        return SessionExtensions.getRequestLogger().getPeakSessions();
    }

    public static IRequestLogger getRequestLogger() {
        return SessionExtensions.getRequestLogger(null);
    }

    public static IRequestLogger getRequestLogger(WebApplication webApplication) {
        IRequestLogger requestLogger = webApplication == null ? ((WebApplication)Application.get()).getRequestLogger() : webApplication.getRequestLogger();
        if (requestLogger == null) {
            requestLogger = new RequestLogger();
        }
        return requestLogger;
    }

    public static int getSessionTimeout() {
        HttpSession session = SessionExtensions.getHttpSession();
        if (session != null) {
            return session.getMaxInactiveInterval();
        }
        return -1;
    }

    public static int setSessionTimeout(int interval) {
        HttpSession session = SessionExtensions.getHttpSession();
        if (session != null) {
            session.setMaxInactiveInterval(interval);
            return interval;
        }
        return -1;
    }
}

