/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.util;

import de.alpharogroup.wicket.base.util.PageProviderFactory;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class RequestHandlerFactory {
    public static IRequestHandler newRequestHandler(PageProvider pageProvider) {
        RenderPageRequestHandler renderPageRequestHandler = new RenderPageRequestHandler((IPageProvider)pageProvider);
        return renderPageRequestHandler;
    }

    public static void schedule(Class<? extends IRequestablePage> pageClass) {
        RequestHandlerFactory.schedule(PageProviderFactory.newPageProvider(pageClass));
    }

    public static void schedule(Class<? extends IRequestablePage> pageClass, PageParameters parameters) {
        RequestHandlerFactory.schedule(PageProviderFactory.newPageProvider(pageClass, parameters));
    }

    public static void schedule(IRequestablePage requestablePage) {
        RequestHandlerFactory.schedule(PageProviderFactory.newPageProvider(requestablePage));
    }

    public static void schedule(IRequestablePage requestablePage, PageParameters parameters) {
        RequestHandlerFactory.schedule(PageProviderFactory.newPageProvider(requestablePage, parameters));
    }

    public static void schedule(IRequestHandler requestHandler) {
        RequestCycle.get().scheduleRequestHandlerAfterCurrent(requestHandler);
    }

    public static void schedule(PageProvider pageProvider) {
        RequestHandlerFactory.schedule(RequestHandlerFactory.newRequestHandler(pageProvider));
    }
}

