/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.request.mapper;

import de.alpharogroup.wicket.base.request.mapper.RequestMapperBean;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.CompoundRequestMapper;
import org.apache.wicket.util.lang.Args;

public class HighScoreRequestMapper
extends CompoundRequestMapper {
    private List<IRequestMapper> requestMappers = new CopyOnWriteArrayList<IRequestMapper>();
    private Comparator<RequestMapperBean> comparator;

    public HighScoreRequestMapper() {
    }

    public HighScoreRequestMapper(List<IRequestMapper> requestMappers) {
        this.requestMappers = (List)Args.notNull(requestMappers, (String)"requestMappers");
    }

    private Comparator<RequestMapperBean> getComparator() {
        if (this.comparator == null) {
            this.comparator = this.newComparator();
        }
        return this.comparator;
    }

    public int getCompatibilityScore(Request request) {
        int score = Integer.MIN_VALUE;
        for (IRequestMapper requestMapper : this.requestMappers) {
            score = Math.max(score, requestMapper.getCompatibilityScore(request));
        }
        return score;
    }

    private Collection<RequestMapperBean> initializeRequestMappers(Request request) {
        TreeSet<RequestMapperBean> mapperBeans = new TreeSet<RequestMapperBean>(this.getComparator());
        for (IRequestMapper requestMapper : this.requestMappers) {
            mapperBeans.add(new RequestMapperBean(requestMapper, requestMapper.getCompatibilityScore(request)));
        }
        return mapperBeans;
    }

    public Url mapHandler(IRequestHandler handler) {
        for (IRequestMapper requestMapper : this.requestMappers) {
            Url url = requestMapper.mapHandler(handler);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public IRequestHandler mapRequest(Request request) {
        for (RequestMapperBean mapperBean : this.initializeRequestMappers(request)) {
            IRequestHandler handler = mapperBean.getMapper().mapRequest(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    protected Comparator<RequestMapperBean> newComparator() {
        return new Comparator<RequestMapperBean>(){

            @Override
            public int compare(RequestMapperBean o1, RequestMapperBean o2) {
                return o1.getCompatibilityScore() - o2.getCompatibilityScore();
            }
        };
    }

    public HighScoreRequestMapper register(IRequestMapper encoder) {
        this.requestMappers.add(0, encoder);
        return this;
    }

    public HighScoreRequestMapper unregister(IRequestMapper encoder) {
        this.requestMappers.remove(encoder);
        return this;
    }
}

