/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.pages;

import de.alpharogroup.lang.AnnotationExtensions;
import de.alpharogroup.wicket.base.pages.SiteUrl;
import de.alpharogroup.wicket.base.util.url.WicketUrlExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PropertyListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketstuff.annotation.mount.MountPath;

public abstract class AbstractSiteMapPage
extends WebPage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)AbstractSiteMapPage.class.getName());
    private static final Pattern PATTERN = Pattern.compile("^\\./");

    public AbstractSiteMapPage() {
        this.add(new Component[]{new PropertyListView<SiteUrl>("urls", this.newListModel()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<SiteUrl> item) {
                item.add(new Component[]{new Label("loc")});
                item.add(new Component[]{new Label("lastmod", (Serializable)((Object)"2014-05-08"))});
            }
        }});
    }

    protected abstract List<? extends Class<? extends WebPage>> getAllPageClasses();

    protected List<? extends Class<? extends WebPage>> getAllPageClassesQuietly() {
        ArrayList<Class> pages = new ArrayList<Class>();
        try {
            Set set = AnnotationExtensions.getAllAnnotatedClasses((String)this.getPackageName(), MountPath.class);
            for (Class class1 : set) {
                pages.add(class1);
            }
        }
        catch (ClassCastException e) {
            LOGGER.error((Object)(e.getClass().getName() + " occured while scanning for MountPath annotations."), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)(e.getClass().getName() + " occured while scanning for MountPath annotations."), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)(e.getClass().getName() + " occured while scanning for MountPath annotations."), (Throwable)e);
        }
        return pages;
    }

    protected String getBaseUrl() {
        return WicketUrlExtensions.getDomainUrl(false);
    }

    public MarkupType getMarkupType() {
        return new MarkupType("html", "text/xml");
    }

    protected abstract String getPackageName();

    private IModel<List<SiteUrl>> newListModel() {
        return new LoadableDetachableModel<List<SiteUrl>>(){
            private static final long serialVersionUID = 1L;

            protected List<SiteUrl> load() {
                ArrayList<SiteUrl> list = new ArrayList<SiteUrl>();
                for (Class<? extends WebPage> clazz : AbstractSiteMapPage.this.getAllPageClasses()) {
                    String loc = PATTERN.matcher(AbstractSiteMapPage.this.urlFor(clazz, null)).replaceFirst(AbstractSiteMapPage.this.getBaseUrl());
                    if (loc.endsWith("/.")) {
                        loc = loc.replace("/.", "");
                    }
                    list.add(new SiteUrl(loc));
                }
                return list;
            }
        };
    }
}

