/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.application.plugins;

import de.alpharogroup.wicket.base.util.application.ApplicationExtensions;
import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;

public class ApplicationDebugSettingsPlugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<ApplicationDebugSettingsPlugin> DEBUG_SETTINGS_PLUGIN_KEY = new MetaDataKey<ApplicationDebugSettingsPlugin>(){
        private static final long serialVersionUID = 1L;
    };

    public static ApplicationDebugSettingsPlugin get() {
        Application app = Application.get();
        if (null == app) {
            throw new IllegalStateException("No wicket application is bound to the current thread.");
        }
        ApplicationDebugSettingsPlugin plugin = (ApplicationDebugSettingsPlugin)app.getMetaData(DEBUG_SETTINGS_PLUGIN_KEY);
        if (null == plugin) {
            String pluginClassName = ApplicationDebugSettingsPlugin.class.getSimpleName();
            throw new IllegalStateException("A " + pluginClassName + " has not been installed in this Wicket application. You have to call " + pluginClassName + ".install() in your application init().");
        }
        return plugin;
    }

    public ApplicationDebugSettingsPlugin install(WebApplication application) {
        Args.notNull((Object)application, (String)"app");
        this.onConfigure(application);
        return this;
    }

    protected void onConfigure(WebApplication application) {
        this.set((Application)application, this);
        ApplicationExtensions.setDefaultDebugSettingsForDevelopment(application);
        application.getMarkupSettings().setStripComments(false);
        application.getMarkupSettings().setCompressWhitespace(false);
        application.getMarkupSettings().setStripWicketTags(false);
    }

    public void set(Application app, ApplicationDebugSettingsPlugin plugin) {
        app.setMetaData(DEBUG_SETTINGS_PLUGIN_KEY, (Object)plugin);
    }
}

