/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.base.application;

import de.alpharogroup.wicket.base.application.WicketConfigurationPropertiesResolver;
import de.alpharogroup.wicket.base.application.plugins.SecuritySettingsPlugin;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.pageStore.DiskDataStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.settings.StoreSettings;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.joda.time.DateTime;

public abstract class BaseWebApplication
extends WebApplication {
    protected static final Logger LOGGER = Logger.getLogger((String)BaseWebApplication.class.getName());
    public static final int DEFAULT_HTTP_PORT = 9090;
    public static final int DEFAULT_HTTPS_PORT = 9443;
    public static final String FOOTER_FILTER_NAME = "footer-container";
    private DateTime startupDate;
    private final Properties properties;
    private final WicketConfigurationPropertiesResolver configurationPropertiesResolver = this.newConfigurationPropertiesResolver(this.getDefaultHttpPort(), this.getDefaultHttpsPort(), "config.properties");

    public BaseWebApplication() {
        this.properties = this.configurationPropertiesResolver.getProperties();
    }

    protected int getDefaultHttpPort() {
        return 9090;
    }

    protected int getDefaultHttpsPort() {
        return 9443;
    }

    public Duration getUptime() {
        DateTime startup = this.getStartupDate();
        if (null != startup) {
            return Duration.elapsed((Time)Time.valueOf((Date)startup.toDate()));
        }
        return Duration.NONE;
    }

    public final void init() {
        this.startupDate = new DateTime();
        super.init();
        this.onApplicationConfigurations();
    }

    public boolean isOnDevelopmentMode() {
        return this.getConfigurationType().equals((Object)RuntimeConfigurationType.DEVELOPMENT);
    }

    public <T extends Page> void mountPage(String path, Class<T> pageClass, IPageParametersEncoder pageParametersEncoder) {
        this.mount((IRequestMapper)new MountedMapper(path, pageClass, pageParametersEncoder));
    }

    protected IDataStore newApplicationDataStore() {
        StoreSettings storeSettings = this.getStoreSettings();
        Bytes maxSizePerSession = storeSettings.getMaxSizePerSession();
        File fileStoreFolder = storeSettings.getFileStoreFolder();
        return new DiskDataStore(this.getName(), fileStoreFolder, maxSizePerSession);
    }

    protected WicketConfigurationPropertiesResolver newConfigurationPropertiesResolver(Integer defaultHttpPort, Integer defaultHttpsPort, String propertiesFilename) {
        return new WicketConfigurationPropertiesResolver(defaultHttpPort, defaultHttpsPort, propertiesFilename);
    }

    protected int newHttpPort() {
        return this.configurationPropertiesResolver.getHttpPort();
    }

    protected int newHttpsPort() {
        return this.configurationPropertiesResolver.getHttpsPort();
    }

    protected void onApplicationConfigurations() {
        this.onBeforeApplicationConfigurations();
        this.onGlobalSettings();
        if (RuntimeConfigurationType.DEVELOPMENT.equals((Object)this.getConfigurationType())) {
            this.onDevelopmentModeSettings();
        }
        if (RuntimeConfigurationType.DEPLOYMENT.equals((Object)this.getConfigurationType())) {
            this.onDeploymentModeSettings();
        }
    }

    protected void onBeforeApplicationConfigurations() {
        this.onSecuritySettingsPlugin(this);
    }

    protected void onDeploymentModeSettings() {
    }

    protected void onDevelopmentModeSettings() {
    }

    protected void onGlobalSettings() {
    }

    protected void onSecuritySettingsPlugin(WebApplication application) {
        new SecuritySettingsPlugin().install(application);
    }

    public DateTime getStartupDate() {
        return this.startupDate;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public WicketConfigurationPropertiesResolver getConfigurationPropertiesResolver() {
        return this.configurationPropertiesResolver;
    }
}

