/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket;

import de.alpharogroup.io.annotations.ImportResource;
import de.alpharogroup.io.annotations.ImportResourcesExtensions;
import de.alpharogroup.wicket.PackageResourceReferenceWrapper;
import de.alpharogroup.wicket.base.enums.ResourceReferenceType;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class PackageResourceReferences {
    private static final PackageResourceReferences instance = new PackageResourceReferences();
    private final Map<Class<?>, Set<PackageResourceReferenceWrapper>> packageResourceReferenceMap = new LinkedHashMap();

    public static void addCssFiles(IHeaderResponse response, Class<?> scope, String ... cssFilenames) {
        for (String cssFilename : cssFilenames) {
            CssReferenceHeaderItem item = CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(scope, cssFilename));
            response.render((HeaderItem)item);
        }
    }

    public static void addJsFiles(IHeaderResponse response, Class<?> scope, String ... jsFilenames) {
        for (String jsFilename : jsFilenames) {
            JavaScriptReferenceHeaderItem item = JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(scope, jsFilename));
            response.render((HeaderItem)item);
        }
    }

    public static PackageResourceReferences getInstance() {
        return instance;
    }

    private Set<PackageResourceReferenceWrapper> addFoundPackageResourceReferences(Set<PackageResourceReferenceWrapper> packageResourceReferences, Class<?> iface) {
        Set<PackageResourceReferenceWrapper> prr = PackageResourceReferences.getInstance().getPackageResourceReferenceMap().get(iface);
        if (packageResourceReferences != null && !packageResourceReferences.isEmpty()) {
            if (prr != null && !prr.isEmpty()) {
                packageResourceReferences.addAll(prr);
            }
        } else if (prr != null && !prr.isEmpty()) {
            packageResourceReferences = prr;
        }
        return packageResourceReferences;
    }

    private Set<PackageResourceReferenceWrapper> addPackageResourceReferenceFromInterfaces(Set<PackageResourceReferenceWrapper> packageResourceReferences, Class<?> searchClass) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = searchClass.getInterfaces()) {
            packageResourceReferences = this.addFoundPackageResourceReferences(packageResourceReferences, iface);
        }
        return packageResourceReferences;
    }

    public Set<PackageResourceReferenceWrapper> getPackageResourceReference(Class<?> componentClass) {
        Set<PackageResourceReferenceWrapper> packageResourceReference = PackageResourceReferences.getInstance().getPackageResourceReferenceMap().get(componentClass);
        packageResourceReference = this.addPackageResourceReferenceFromInterfaces(packageResourceReference, componentClass);
        return packageResourceReference;
    }

    public Map<Class<?>, Set<PackageResourceReferenceWrapper>> getPackageResourceReferenceMap() {
        return this.packageResourceReferenceMap;
    }

    public void initializeResources(List<String> packageNames) throws ClassNotFoundException, IOException {
        for (String packageName : packageNames) {
            this.initializeResources(packageName);
        }
    }

    public void initializeResources(String packageName) throws ClassNotFoundException, IOException {
        Map resourcesMap = ImportResourcesExtensions.getImportResources((String)packageName);
        for (Map.Entry entry : resourcesMap.entrySet()) {
            Class key = (Class)entry.getKey();
            ImportResource[] value = (ImportResource[])entry.getValue();
            LinkedHashSet<PackageResourceReferenceWrapper> packageResourceReferences = new LinkedHashSet<PackageResourceReferenceWrapper>();
            for (ImportResource importResource : value) {
                PackageResourceReference t;
                if (importResource.resourceType().equalsIgnoreCase("js")) {
                    t = new PackageResourceReference(key, importResource.resourceName());
                    packageResourceReferences.add(new PackageResourceReferenceWrapper(t, ResourceReferenceType.JS));
                    continue;
                }
                if (!importResource.resourceType().equalsIgnoreCase("css")) continue;
                t = new PackageResourceReference(key, importResource.resourceName());
                packageResourceReferences.add(new PackageResourceReferenceWrapper(t, ResourceReferenceType.CSS));
            }
            PackageResourceReferences.getInstance().getPackageResourceReferenceMap().put(key, packageResourceReferences);
        }
    }

    public void initializeResources(String[] packageNames) throws ClassNotFoundException, IOException {
        this.initializeResources(Arrays.asList(packageNames));
    }
}

