/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import de.alpharogroup.gson.factory.TypeFactory;
import java.util.List;
import java.util.Objects;

public final class ObjectToJsonExtensions {
    private static final Gson DEFAULT_GSON = new Gson();

    private ObjectToJsonExtensions() {
    }

    public static <T> String toJson(List<T> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return "";
        }
        return DEFAULT_GSON.toJson(list, TypeFactory.newListTypeToken(list.get(0).getClass()));
    }

    public static <T> String toJson(T object) {
        Objects.requireNonNull(object);
        return DEFAULT_GSON.toJson(object, object.getClass());
    }
}

