/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import de.alpharogroup.gson.factory.TypeFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonStringToObjectExtensions {
    private static final Gson DEFAULT_GSON = new Gson();

    private JsonStringToObjectExtensions() {
    }

    public static <K, V> Map<K, V> toMapObject(String jsonString, Class<K> keyType, Class<V> valueType) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(keyType);
        Objects.requireNonNull(valueType);
        return (Map)DEFAULT_GSON.fromJson(jsonString, TypeFactory.newMapTypeToken(keyType, valueType));
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(clazz);
        return (T)DEFAULT_GSON.fromJson(jsonString, clazz);
    }

    public static <T> Collection<T> toObjectCollection(String jsonString, Class<? extends Collection> collectionClass, Class<T> elementClass) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(collectionClass);
        Objects.requireNonNull(elementClass);
        return (Collection)DEFAULT_GSON.fromJson(jsonString, TypeFactory.newCollectionTypeToken(collectionClass, elementClass));
    }

    public static <T> List<T> toObjectList(String jsonString, Class<T> elementClass) {
        Objects.requireNonNull(jsonString);
        Objects.requireNonNull(elementClass);
        return (List)JsonStringToObjectExtensions.toObjectCollection(jsonString, List.class, elementClass);
    }
}

