/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.alpharogroup.gson.factory.GsonFactory;
import de.alpharogroup.gson.factory.TypeFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

public final class JsonFileToObjectExtensions {
    private static final Gson DEFAULT_GSON = GsonFactory.newGson();

    private JsonFileToObjectExtensions() {
    }

    public static <T> T toObject(File jsonFile, Class<T> clazz) throws IOException {
        return (T)DEFAULT_GSON.fromJson((Reader)new FileReader(jsonFile), clazz);
    }

    public static <T> List<T> toObjectList(File jsonListFile, Class<T> clazz) throws IOException {
        Type listType = TypeFactory.newListTypeToken(clazz);
        JsonReader reader = new JsonReader((Reader)new FileReader(jsonListFile));
        return (List)DEFAULT_GSON.fromJson(reader, listType);
    }
}

