/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson;

import de.alpharogroup.gson.JsonStringToObjectExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public final class JSONObjectToObjectExtensions {
    private JSONObjectToObjectExtensions() {
    }

    public static <T> T toObject(JSONObject jsonObject, Class<T> clazz) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(clazz);
        return JsonStringToObjectExtensions.toObject(jsonObject.toString(), clazz);
    }

    public static <T> List<T> toObjectList(JSONArray jsonArray, Class<T> elementClass) {
        Objects.requireNonNull(jsonArray);
        Objects.requireNonNull(elementClass);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object object = jsonArray.get(i);
            list.add(object.toString());
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(JsonStringToObjectExtensions.toObject((String)list.get(i), elementClass));
        }
        return result;
    }
}

