/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.gson.type.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class BigDecimalMoneyScaledAdapter
extends TypeAdapter<BigDecimal> {
    public void write(JsonWriter out, BigDecimal value) throws IOException {
        out.value(value == null ? null : value.setScale(2, RoundingMode.DOWN));
    }

    public BigDecimal read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToBigDecimal(in.nextString());
    }

    private synchronized BigDecimal deserializeToBigDecimal(String json) {
        BigDecimal bigDecimal = new BigDecimal(json);
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        return new BigDecimal(nf.format(bigDecimal));
    }
}

